function $_GET(param) {
    let vars = {};
    window.location.href.replace(location.hash, '').replace(
        /[?&]+([^=&]+)=?([^&]*)?/gi, // regexp
        function (m, key, value) { // callback
            vars[key] = value !== undefined ? value : '';
        }
    );

    if (param) {
        return vars[param] ? vars[param] : null;
    }
    return vars;
}

function handleApiError(_function) {
    try{
        _function;
    } catch (e) {
        console.error(e);
    }
}

function setDisplayName(apiData) {
    $("#api_lfm_display_name").html(apiData.display_name);
}
let timesinceshowstart;
function setCurrentPlaylist(apiData) {
    $(".show_start").html(apiData.current_playlist.hour);
    $(".show_name").html(apiData.current_playlist.name);
    $(".fullscreen_show_name").html(apiData.current_playlist.name);
    $(".fullscreen_show_description").html(apiData.current_playlist.description);
    $(".fullscreen_show_timing").html(apiData.current_playlist.hour + ' &ndash; ' + apiData.next_playlist.hour + ' Uhr');
    $(".fullscreen_show_start").html(apiData.current_playlist.hour +':00');
    $(".fullscreen_show_end").html(apiData.next_playlist.hour +':00');
    let themingImage = 'https://cdn.tbrmedia.de/sounds/funfm/showcover/'+apiData.current_playlist.id+'.png';
    $(".show_theming")[0].style.background = 'url('+themingImage+')';
    $(".player_showcover")[0].src = themingImage;
    $(".playerbar-showname").html("&nbsp;&nbsp;FUN FM  " + apiData.current_playlist.name);
    $(".show_description").html(apiData.current_playlist.description);
    let end_time = apiData.next_playlist.hour;
    let end_time_new = end_time === 0 ? 24 : end_time;
    let ShowDurationMinutes = ((end_time_new - apiData.current_playlist.hour) % 24) * 60;
    let ShowStart = new Date("1990-01-01T" + apiData.current_playlist.hour + ":00:00");
    let CurrentSeconds = ('0' + new Date().getSeconds()).slice(-2);
    let CurrentMinutes = ('0' + new Date().getMinutes()).slice(-2);
    let CurrentHour = ('0' + new Date().getHours()).slice(-2);
    let CurrentTime = new Date("1990-01-01T" + (CurrentHour + ':' +  CurrentMinutes + ":" + CurrentSeconds));
    let DefferenceTime = (CurrentTime - ShowStart)/1000/60;
    let timesinceshowstart = (CurrentTime - ShowStart)/1000/60;
    let ShowProgressInPercent = Math.round((DefferenceTime/ShowDurationMinutes)*100*100)/100;
    $(".fullscreen_show_progress_bar")[0].style.width = ShowProgressInPercent+'%';
    $(".schedule-current-programme-time-progress")[0].style.width = ShowProgressInPercent+'%';
    $(".show-progress-stage")[0].style.width = ShowProgressInPercent+'%';

}

function setNextPlaylist(apiData) {
    $(".next_start").html(apiData.next_playlist.hour);
    $(".next_name").html(apiData.next_playlist.name);
    $(".next_description").html(apiData.next_playlist.description);
}

function setStationInformation(apiData) {
    $("#station_logo").attr('src', apiData.images.station_640x640 || apiData.images.station_120x120);
    $("#station_displayname").html(apiData.display_name);
    $("#station_slogan").html(apiData.format);
    $("#station_description").html(apiData.description);
    /* Handle new and old api. */
    let website     = apiData.website       || apiData.third_parties.website.url;
    let facebook    = apiData.facebook_page || apiData.third_parties.facebook.page;
    let twitter     = apiData.twitter_name  || apiData.third_parties.twitter.name;
    handleApiError(website ? $("#hp-link").attr('href', website) : $("#hp-link").hide());
    handleApiError(apiData.page_url ? $("#lfm-link").attr('href', apiData.page_url) : $("#lfm-link").hide());
    handleApiError(apiData.third_parties.rss ? $("#rss-link").attr('href', apiData.third_parties.rss.url) : $("#rss-link").hide());
    handleApiError(facebook ? $("#fb-link").attr('href', facebook) : $("#fb-link").hide());
    handleApiError(twitter ? $("#tw-link").attr('href', "https://twitter.com/" + twitter) : $("#tw-link").hide());
    handleApiError(apiData.third_parties.instagram ? $("#ig-link").attr('href', "https://instagram.com/" + apiData.third_parties.instagram.name) : $("#ig-link").hide());
    handleApiError(apiData.third_parties.radiode ? $("#radiode-link").attr('href', apiData.third_parties.radiode.url): $("#radiode-link").hide());
    handleApiError(apiData.third_parties.phonostar ? $("#phonostar-link").attr('href', apiData.third_parties.phonostar.url) : $("#phonostar-link").hide());
    handleApiError(apiData.third_parties.tunein ? $("#tunein-link").attr('href', apiData.third_parties.tunein.url) : $("#tunein-link").hide());
    handleApiError($("#m3u-link").attr('href', apiData.stream_url + ".m3u"));
    handleApiError($("#pls-link").attr('href', apiData.stream_url + ".pls"));
}

function crawleLautApi(station_name) {
    $.getJSON("https://api.laut.fm/station/" + station_name, function (data) {
        setDisplayName(data);
        changeFavicon(data);
        createWebApp(data);
        document.title = data.display_name.toUpperCase() + " - SOUNDS";
        station_info && setStationInformation(data);
        current_show && setCurrentPlaylist(data);
        next_show && setNextPlaylist(data);
    });
}

function crawlePlaylist(station_name) {
    $.getJSON("https://api.laut.fm/station/" + station_name, function (data) {
        current_show && setCurrentPlaylist(data);
        next_show && setNextPlaylist(data);
    });
}

function changeFavicon(apiData) {
    document.head || (document.head = document.getElementsByTagName('head')[0]);
    let link = document.createElement('link'),
        oldLink = document.getElementById('dynamic-favicon');
    link.id = 'dynamic-favicon';
    link.rel = 'shortcut icon';
    link.href = 'https://static.tbrnet.de/images/funfm/sounds/logos/appicond_brand.png';
    if (oldLink) {
        document.head.removeChild(oldLink);
    }
    document.head.appendChild(link);
}

function createWebApp(apiData) {
    document.head || (document.head = document.getElementsByTagName('head')[0]);
    let link1 = document.createElement('link'),
        oldLink1 = document.getElementById('dynamic-webapp-1');
    link1.id = 'dynamic-webapp-1';
    link1.rel = 'icon';
    link1.type = 'image/png';
    link1.size = '96x96';
    link1.href = 'https://static.tbrnet.de/images/funfm/sounds/logos/appicond_brand.png';
    if (oldLink1) {
        document.head.removeChild(oldLink1);
    }
    document.head.appendChild(link1);

    document.head || (document.head = document.getElementsByTagName('head')[0]);
    let link2 = document.createElement('link'),
        oldLink2 = document.getElementById('dynamic-webapp-2');
    link2.id = 'dynamic-webapp-2';
    link2.rel = 'icon';
    link2.type = 'image/png';
    link2.size = '32x32';
    link2.href = 'https://static.tbrnet.de/images/funfm/sounds/logos/appicond_brand.png';
    if (oldLink2) {
        document.head.removeChild(oldLink2);
    }
    document.head.appendChild(link2);

    document.head || (document.head = document.getElementsByTagName('head')[0]);
    let link3 = document.createElement('meta'),
        oldLink3 = document.getElementById('dynamic-webapp-3');
    link3.id = 'dynamic-webapp-3';
    link3.name = 'theme-color';
    link3.content = '#141414';
    if (oldLink3) {
        document.head.removeChild(oldLink3);
    }
    document.head.appendChild(link3);

    document.head || (document.head = document.getElementsByTagName('head')[0]);
    let link4 = document.createElement('link'),
        oldLink4 = document.getElementById('dynamic-webapp-4');
    link4.id = 'dynamic-webapp-4';
    link4.rel = 'apple-touch-icon';
    link4.size = '180x180';
    link4.href = 'https://static.tbrnet.de/images/funfm/sounds/logos/appicond_brand@2x.png';
    if (oldLink4) {
        document.head.removeChild(oldLink4);
    }
    document.head.appendChild(link4);

    document.head || (document.head = document.getElementsByTagName('head')[0]);
    let link5 = document.createElement('meta'),
        oldLink5 = document.getElementById('dynamic-webapp-5');
    link5.id = 'dynamic-webapp-5';
    link5.name = 'msapplication-TileColor';
    link5.content = '#141414';
    if (oldLink5) {
        document.head.removeChild(oldLink5);
    }
    document.head.appendChild(link5);

    document.head || (document.head = document.getElementsByTagName('head')[0]);
    let link6 = document.createElement('meta'),
        oldLink6 = document.getElementById('dynamic-webapp-6');
    link6.id = 'dynamic-webapp-6';
    link6.name = 'msapplication-TileImage';
    link6.content = 'https://static.tbrnet.de/images/funfm/sounds/logos/appicond_brand@2x.png';
    if (oldLink6) {
        document.head.removeChild(oldLink6);
    }
    document.head.appendChild(link6);

    document.head || (document.head = document.getElementsByTagName('head')[0]);
    let link7 = document.createElement('link'),
        oldLink7 = document.getElementById('dynamic-webapp-7');
    link7.id = 'dynamic-webapp-7';
    link7.rel = 'shortcut icon';
    link7.sizes = '1024x1024';
    link7.href = 'https://static.tbrnet.de/images/funfm/sounds/logos/appicond_brand@4x.png';
    if (oldLink7) {
        document.head.removeChild(oldLink7);
    }
    document.head.appendChild(link7);
}

function getSong(station_name) {
    $.getJSON("https://api.laut.fm/station/" + station_name + "/current_song", function (current) {
        if (song_str !== (current.title + " " + current.artist.name)) {
            song_str = current.title + " " + current.artist.name;
            $("#api_lfm_current_song1").html("<artist>" + current.artist.name + "</artist> mit: " + "<song>" + current.title + "</song>");
            $("#api_lfm_current_song2").html("<artist2>" + current.artist.name + "</artist2> &ndash; " + "<song2>" + current.title + "</song2>");
            $(".fullscreen_metadata_artist").html(current.artist.name);
            $(".fullscreen_metadata_title").html(current.title);
        }
    })
}


function getWidth() {
    let wrapper = $("#nowplaying").width();
    let wrapper2 = $(".playerbar-titleupdate").width();
    let playing = $("#api_lfm_display_name").width() + $("#nowplaying span").width();
    $("#api_lfm_current_song1").width(wrapper - playing);
    $("#api_lfm_current_song2").width(wrapper2);
}

//let globalHookId;
//document.querySelector('.hookbtn').addEventListener('click', function() {
//    globalHookId = this.getAttribute('data-hook');
//});
let live = true;
let hlslive = false;
function audiobtn() {
    let aud = $('video')[0];
    aud.src = 'https://stream.laut.fm/' + station;
    aud.title = sender + ' - LIVE';
    $('.playbtn').on('click', function () {
        if (aud.paused) {
            aud.play();
            live = true;
            let hlslive = false;
            $('.play-pause').removeClass('fa-play').addClass('fa-stop');
            $('.icon.audio').removeClass('hidden');
            $('.playerbar-showname').removeClass('d-none');
            $('.playerbar-titleupdate').removeClass('d-none')
            $('.playerbar-aod').addClass('d-block');

        } else {
            live = true;
            let hlslive = false;
            aud.pause();
            $('.play-pause').removeClass('fa-stop').addClass('fa-play');
            $('.icon.audio').addClass('hidden');
            $('.playerbar-showname').removeClass('d-none');
            $('.playerbar-titleupdate').removeClass('d-none');
            $('.playerbar-aod').addClass('d-block');
        }

    })
    $('.mutebtn').on('click', function(){
        if (aud.muted == false) {
            aud.muted = true;
            $('.mute-unmute').removeClass('fa-volume-up');
            $('.mute-unmute').addClass('fa-volume-mute');
            $('.mute-unmute').addClass('muted');
        }
        else {
            aud.muted = false;
            $('.mute-unmute').removeClass('fa-volume-mute');
            $('.mute-unmute').removeClass('muted');
            $('.mute-unmute').addClass('fa-volume-up');
        }
    })
    $('.newsbtn').on('click', function () {
        if (aud.paused) {
            aud.src = 'https://static.tbrnet.de/streaming/audio/service.mp3';
            aud.title = 'FUN FM - DIE NACHRICHTEN';
            aud.play();
            live = false;
            let hlslive = false;
            $('.play-pause').removeClass('fa-play').addClass('fa-stop');
            $('.icon.audio').removeClass('hidden');
            $('.playerbar-showname').addClass('d-none');
            $('.playerbar-titleupdate').addClass('d-none');
            $(".playerbar-aod").html("FUN FM DIE NACHRICHTEN").removeClass('d-none');

        } else {
            aud.src = 'https://static.tbrnet.de/streaming/audio/service.mp3';
            aud.title = 'FUN FM - DIE NACHRICHTEN';
            aud.play();
            live = false;
            let hlslive = false;
            $('.playerbar-showname').addClass('d-none');
            $('.playerbar-titleupdate').addClass('d-none');
            $(".playerbar-aod").html("FUN FM DIE NACHRICHTEN").removeClass('d-none');
        }
    })
    $('.weatherbtn').on('click', function () {
        if (aud.paused) {
            aud.src = 'https://static.tbrnet.de/streaming/audio/wetter.mp3';
            aud.title = 'FUN FM - DAS WETTER';
            aud.play();
            live = false;
            let hlslive = false;
            $('.play-pause').removeClass('fa-play').addClass('fa-stop');
            $('.icon.audio').removeClass('hidden');
            $('.playerbar-showname').addClass('d-none');
            $('.playerbar-titleupdate').addClass('d-none');
            $(".playerbar-aod").html("FUN FM DAS WETTER").removeClass('d-none');

        } else {
            aud.src = 'https://static.tbrnet.de/streaming/audio/wetter.mp3';
            aud.title = 'FUN FM - DAS WETTER';
            aud.play();
            live = false;
            let hlslive = false;
            $('.playerbar-showname').addClass('d-none');
            $('.playerbar-titleupdate').addClass('d-none');
            $(".playerbar-aod").html("FUN FM DAS WETTER").removeClass('d-none');
        }
    })
    $('.livebtn').on('click', function () {
        if (aud.paused && Hls.isSupported()) {
            aud.src = 'https://streaming.tbrmedia.de/hls/fun_fm/live.m3u8';
            var audsrc = 'https://streaming.tbrmedia.de/hls/fun_fm/live.m3u8' ;
            aud.title = sender + ' - LIVE';
            var hls = new Hls();
            hls.loadSource(audsrc);
            hls.attachMedia(aud);
            aud.play();
            live = true;
            let hlslive = true;
            $('.play-pause').removeClass('fa-play').addClass('fa-stop');
            $('.icon.audio').removeClass('hidden');
            $('.playerbar-showname').removeClass('d-none');
            $('.playerbar-titleupdate').removeClass('d-none');
            $('.playerbar-aod').addClass('d-none');
        } else if (aud.canPlayType('application/vnd.apple.mpegurl')) {
            aud.src = 'https://streaming.tbrmedia.de/hls/fun_fm/live.m3u8';
            aud.title = sender + ' - LIVE';
            aud.play();
            live = true;
            let hlslive = true;
            $('.play-pause').removeClass('fa-play').addClass('fa-stop');
            $('.icon.audio').removeClass('hidden');
            $('.playerbar-showname').removeClass('d-none');
            $('.playerbar-titleupdate').removeClass('d-none');
            $('.playerbar-aod').addClass('d-none');
        } else {
            aud.src = 'https://stream.laut.fm/' + station;
            aud.title = sender + ' - LIVE';
            aud.play();
            live = true;
            let hlslive = false;
            $('.playerbar-showname').removeClass('d-none');
            $('.playerbar-titleupdate').removeClass('d-none');
            $('.playerbar-aod').addClass('d-none');
            $('.play-pause').removeClass('fa-play').addClass('fa-stop');
        }
    })
    $(document).on('click', '.hookbtn', function () {
        HookId = this.getAttribute('data-hook');
        if (aud.paused) {
            aud.src = 'https://cdn.tbrmedia.de/sounds/funfm/hooks/preview_'+HookId+'.mp3';
            aud.title = 'Songvorschau';
            aud.play();
            live = false;
            let hlslive = false;
            $('.play-pause').removeClass('fa-play').addClass('fa-stop');
            $('.icon.audio').removeClass('hidden');
            $('.playerbar-showname').addClass('d-none');
            $('.playerbar-titleupdate').addClass('d-none');
            $(".playerbar-aod").html("Songvorschau").removeClass('d-none');

        } else {
            aud.src = 'https://cdn.tbrmedia.de/sounds/funfm/hooks/preview_'+HookId+'.mp3';
            aud.title = 'Songvorschau';
            aud.play();
            live = false;
            let hlslive = false;
            $('.playerbar-showname').addClass('d-none');
            $('.playerbar-titleupdate').addClass('d-none');
            $(".playerbar-aod").html("Songvorschau").removeClass('d-none');
        }
    })
    $(document).on('click', '.episode-button', function () {
        streamingurl= this.getAttribute('data-streaming');
        streamingname = this.getAttribute('data-name')
        streamingimage = this.getAttribute('data-image')
        if (aud.paused) {
            aud.src = streamingurl;
            aud.title = streamingname;
            aud.play();
            live = false;
            let hlslive = false;
            $('.play-pause').removeClass('fa-play').addClass('fa-stop');
            $('.icon.audio').removeClass('hidden');
            $('.playerbar-showname').addClass('d-none');
            $('.playerbar-titleupdate').addClass('d-none');
            $(".playerbar-aod").html(streamingname).removeClass('d-none');


        } else {
            aud.src = streamingurl;
            aud.title = streamingname;
            aud.play();
            live = false;
            let hlslive = false;
            $('.playerbar-showname').addClass('d-none');
            $('.playerbar-titleupdate').addClass('d-none');
            $(".playerbar-aod").html(streamingname).removeClass('d-none');

        }
    })
}

window.setInterval(CheckPlayerState, 5000);

function CheckPlayerState() {
    let aud = $('video')[0];
    if (aud.paused) {
    }
    if (!aud.paused && live === false ) {

    }
    if (!aud.paused && live === true ) {
        updateMetadata();
        sharing();
        updateSeekingButtons();
    }
    else {

    }
}

function startTimer(minutes) {
    let audioPlayer = $('video')[0];
    if (!audioPlayer.paused) {
        setTimeout(function () {
            audioPlayer.currentTime = 0;
            audioPlayer.pause;
        }, minutes * 60 * 1000);
    }
}

function updateMetadata(currentshowcover) {
    $.getJSON("https://api.laut.fm/station/" + station + "/current_song", function (current) {
        let npartist = current.artist.name;
        let nptitle = current.title;
        let currentshowcover = document.querySelector('img.player_showcover').src;
        navigator.mediaSession.metadata = new MediaMetadata({
            title: nptitle,
            artist: npartist,
            album: 'FUN FM',
            artwork: [
                {src: currentshowcover, sizes: "56x56", type: "image/png"},
                {src: currentshowcover, sizes: "64x64", type: "image/png"},
                {src: currentshowcover, sizes: "72x72", type: "image/png"},
                {src: currentshowcover, sizes: "96x96", type: "image/png"},
                {src: currentshowcover, sizes: "128x128", type: "image/png"},
                {src: currentshowcover, sizes: "192x192", type: "image/png"},
                {src: currentshowcover, sizes: "256x256", type: "image/png"},
                {src: currentshowcover, sizes: "384x384", type: "image/png"},
                {src: currentshowcover, sizes: "512x512", type: "image/png"},
                {src: currentshowcover, sizes: "640x640", type: "image/png"}
            ],
        });
        if (nptitle==='DIE NACHRICHTEN') {
            $.getJSON("https://api.laut.fm/station/" + station , function (apiData) {
                navigator.mediaSession.metadata = new MediaMetadata({
                    title: nptitle,
                    artist: npartist,
                    album: 'FUN FM',
                    artwork: [
                        {src: 'https://static.tbrnet.de/images/funfm/cover/Nachrichten.jpg', sizes: "56x56", type: "image/jpg"},
                        {src: 'https://static.tbrnet.de/images/funfm/cover/Nachrichten.jpg', sizes: "64x64", type: "image/jpg"},
                        {src: 'https://static.tbrnet.de/images/funfm/cover/Nachrichten.jpg', sizes: "72x72", type: "image/jpg"},
                        {src: 'https://static.tbrnet.de/images/funfm/cover/Nachrichten.jpg', sizes: "96x96", type: "image/jpg"},
                        {src: 'https://static.tbrnet.de/images/funfm/cover/Nachrichten.jpg', sizes: "128x128", type: "image/jpg"},
                        {src: 'https://static.tbrnet.de/images/funfm/cover/Nachrichten.jpg', sizes: "192x192", type: "image/jpg"},
                        {src: 'https://static.tbrnet.de/images/funfm/cover/Nachrichten.jpg', sizes: "256x256", type: "image/jpg"},
                        {src: 'https://static.tbrnet.de/images/funfm/cover/Nachrichten.jpg', sizes: "384x384", type: "image/jpg"},
                        {src: 'https://static.tbrnet.de/images/funfm/cover/Nachrichten.jpg', sizes: "512x512", type: "image/jpg"},
                        {src: 'https://static.tbrnet.de/images/funfm/cover/Nachrichten.jpg', sizes: "640x640", type: "image/jpg"}
                    ],
                });
            });
        } if (nptitle==='DAS WETTER') {
            $.getJSON("https://api.laut.fm/station/" + station , function (apiData) {
                navigator.mediaSession.metadata = new MediaMetadata({
                    title: nptitle,
                    artist: npartist,
                    album: 'FUN FM',
                    artwork: [
                        {src: 'https://static.tbrnet.de/images/funfm/cover/Wetter.jpg', sizes: "56x56", type: "image/jpg"},
                        {src: 'https://static.tbrnet.de/images/funfm/cover/Wetter.jpg', sizes: "64x64", type: "image/jpg"},
                        {src: 'https://static.tbrnet.de/images/funfm/cover/Wetter.jpg', sizes: "72x72", type: "image/jpg"},
                        {src: 'https://static.tbrnet.de/images/funfm/cover/Wetter.jpg', sizes: "96x96", type: "image/jpg"},
                        {src: 'https://static.tbrnet.de/images/funfm/cover/Wetter.jpg', sizes: "128x128", type: "image/jpg"},
                        {src: 'https://static.tbrnet.de/images/funfm/cover/Wetter.jpg', sizes: "192x192", type: "image/jpg"},
                        {src: 'https://static.tbrnet.de/images/funfm/cover/Wetter.jpg', sizes: "256x256", type: "image/jpg"},
                        {src: 'https://static.tbrnet.de/images/funfm/cover/Wetter.jpg', sizes: "384x384", type: "image/jpg"},
                        {src: 'https://static.tbrnet.de/images/funfm/cover/Wetter.jpg', sizes: "512x512", type: "image/jpg"},
                        {src: 'https://static.tbrnet.de/images/funfm/cover/Wetter.jpg', sizes: "640x640", type: "image/jpg"}
                    ],
                });
            });
        } else {
            $.getJSON("https://api.laut.fm/station/" + station , function (apiData) {
                navigator.mediaSession.metadata = new MediaMetadata({
                    title: nptitle,
                    artist: npartist,
                    album: 'FUN FM',
                    artwork: [
                        {src: currentshowcover, sizes: "56x56", type: "image/png"},
                        {src: currentshowcover, sizes: "64x64", type: "image/png"},
                        {src: currentshowcover, sizes: "72x72", type: "image/png"},
                        {src: currentshowcover, sizes: "96x96", type: "image/png"},
                        {src: currentshowcover, sizes: "128x128", type: "image/png"},
                        {src: currentshowcover, sizes: "192x192", type: "image/png"},
                        {src: currentshowcover, sizes: "256x256", type: "image/png"},
                        {src: currentshowcover, sizes: "384x384", type: "image/png"},
                        {src: currentshowcover, sizes: "512x512", type: "image/png"},
                        {src: currentshowcover, sizes: "640x640", type: "image/png"}
                    ],
                });
            });
        }
    });
}



navigator.mediaSession.setActionHandler('play', function() { let aud = $('video')[0]; aud.play(); });
navigator.mediaSession.setActionHandler('pause', function() { let aud = $('video')[0]; aud.stop();});
navigator.mediaSession.setActionHandler("seekbackward", () => { let aud = $('video')[0]; aud.currentTime -= 10;  });
navigator.mediaSession.setActionHandler("seekforward", () => { let aud = $('video')[0]; aud.currentTime += 10; });

function sharing() {
    let sharingbtn = document.querySelector('.sharing-button');
    let sharingbtn2 = document.querySelector('.desktop-sharer');
    let resultPara = document.querySelector('.result');

    async function handleShareClick() {
        try {
            let current = await $.getJSON("https://api.laut.fm/station/" + station + "/current_song");
            let npsartist = current.artist.name;
            let npstitle = current.title;

            let currentUrl = window.location.href;

            let shareData = {
                title: 'Ich höre gerade FUN FM',
                text: 'Jetzt läuft: ' + npsartist + ' – ' + npstitle,
                url: currentUrl
            };

            await navigator.share(shareData);
            resultPara.textContent = 'MDN shared successfully';
        } catch (err) {
            resultPara.textContent = `Error: ${err}`;
        }
    }

    sharingbtn.addEventListener('click', handleShareClick);
    sharingbtn2.addEventListener('click', handleShareClick);
}




function SetVolume(val)
{
    let player = $('video')[0];
    let slider = $("#vol-control")[0];
    player.volume = val / 100;
    slider.title = val + " %";
}

function SetSlider(val) {
    let slider = $("#vol-control")[0];
    slider.value = val;
    slider.title = val + " %";
}


// HLS Seeking in UI

// Function to update the buttons for seeking
function updateSeekingButtons() {
    const video = $('video')[0];
    if (hlslive) {
        // Show the four buttons for seeking
        document.getElementById('seekBackTimeSinceShowStart').style.display = 'inline-block';
        document.getElementById('seekBackTimeSinceShowStart').addEventListener('click', function() {
            video.currentTime = timesinceshowstart * 60; // Set the current time to the value of timesinceshowstart in seconds
        });

        document.getElementById('seekBack10Seconds').style.display = 'inline-block';
        document.getElementById('seekBack10Seconds').addEventListener('click', function() {
            video.currentTime -= 20; // Subtract 10 seconds from the current time
            // Trigger the seek animation
            triggerSeekAnimationrwd();
        });

        document.getElementById('seekForward10Seconds').style.display = 'inline-block';
        document.getElementById('seekForward10Seconds').addEventListener('click', function() {
            video.currentTime += 20; // Add 10 seconds to the current time
            // Trigger the seek animation
            triggerSeekAnimationfwd();
        });

        document.getElementById('goToLivePosition').style.display = 'inline-block';
        document.getElementById('goToLivePosition').addEventListener('click', function() {
            video.currentTime = video.duration; // Set the current time to the end of the video (the live position)
        });
    } else {
        // Hide the four buttons for seeking
        document.getElementById('seekBackTimeSinceShowStart').style.display = 'none';
        document.getElementById('seekBackTimeSinceShowStart').removeEventListener('click', function() {});
        document.getElementById('seekBack10Seconds').style.display = 'none';
        document.getElementById('seekBack10Seconds').removeEventListener('click', function() {});
        document.getElementById('seekForward10Seconds').style.display = 'none';
        document.getElementById('seekForward10Seconds').removeEventListener('click', function() {});
        document.getElementById('goToLivePosition').style.display = 'none';
        document.getElementById('goToLivePosition').removeEventListener('click', function() {});
    }
}

// Call the updateSeekingButtons() function initially to set up the buttons
updateSeekingButtons();

// Check the value of hlslive periodically
setInterval(function() {
    // Set hlslive to true or false depending on whether HLS Streaming is used or not
    hlslive = true; // Set to true if HLS Streaming is used
    timesinceshowstart = 0; // Set to the current time in minutes

    updateSeekingButtons();
}, 1000); // Check the value of hlslive every second

// Function to trigger the seek animation
function triggerSeekAnimationfwd() {
    const seekArrow = document.getElementById('seekArrowfwd');
    const seekArrowFull = document.getElementsByClassName('fwd_20s_icon');
    seekArrow.style.transform = 'rotateZ(55deg)';// Rotate the arrow 5 degrees

    setTimeout(function() {
        seekArrow.style.transform = 'rotate(0deg)'; // Rotate the arrow back to its original position

    }, 500); // Set a timeout of 500 milliseconds (0.5 seconds) before rotating the arrow back
}
function triggerSeekAnimationrwd() {
    const seekArrow = document.getElementById('seekArrowrwd');
    const seekArrowFull = document.getElementsByClassName('bwd_20s_icon');
    seekArrow.style.transform = 'rotateZ(-55deg)'; // Rotate the arrow 5 degrees

    setTimeout(function() {
        seekArrow.style.transform = 'rotate(0deg)'; // Rotate the arrow back to its original position
        
    }, 500); // Set a timeout of 500 milliseconds (0.5 seconds) before rotating the arrow back
}