// SwiperJS detects swipe gestures and converts them to Sounds Interactions
// Version 0.0.1a - 2023-09-05

// Swipe Down to Refresh with Cache clearing
let touchStartY = 0;
let touchEndY = 0;
const threshold = 100; // The distance needed for it to be considered a swipe

window.addEventListener('touchstart', function(event) {
    touchStartY = event.changedTouches[0].screenY;
});

window.addEventListener('touchend', function(event) {
    touchEndY = event.changedTouches[0].screenY;
    handleSwipe();
});

function handleSwipe() {
    if (touchEndY > touchStartY + threshold) {
        // A downward swipe was detected
        refreshAndClearCache();
    }
}

function refreshAndClearCache() {
    // If you named your cache, use that name here
    const cacheName = 'soundscache';

    window.history.replaceState(null, document.title, location.href);
    window.addEventListener('popstate', function (event) {
        history.forward();
    });

    caches.open(cacheName).then(cache => {
        cache.keys().then(requests => {
            requests.forEach(request => {
                cache.delete(request);
            });
            // Once the cache is cleared, refresh the page
            location.reload();
        });
    });
}



// Swipe from right or left corner for changing main view
