<!DOCTYPE html>
<html lang="de" xmlns="http://www.w3.org/1999/html">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, shrink-to-fit=no">
    <link rel="stylesheet" href="assets/css/dev-loader.css">

    <link rel="dns-prefetch" href="https://fun-fm.de" crossorigin />
    <link rel="dns-prefetch" href="https://blog.fun-fm.de" crossorigin />
    <link rel="dns-prefetch" href="https://tbrnet.de" crossorigin />
    <link rel="dns-prefetch" href="https://static.tbrnet.de" crossorigin />
    <link rel="dns-prefetch" href="https://hls.fun-fm.com" crossorigin />
    <link rel="dns-prefetch" href="https://api.laut.fm" crossorigin />
    <link rel="dns-prefetch" href="https://assets.laut.fm" crossorigin />


    <!--WebApp Basics-->
    <meta name="apple-mobile-web-app-capable" content="yes"/>
    <meta name="apple-mobile-web-app-status-bar-style" content="black">


    <!--OpenGraph-->
    <meta property="og:site_name" content="fun-fm.de" />
    <meta property="article:tag" content="FUN FM - SOUNDS" />
    <meta property="og:type" content="article">
    <meta property="og:description" content="Online. On the phone. On the Smartspeaker. On Demand. FUN FM SOUNDS" />
    <meta property="og:image" content="https://static.tbrnet.de/images/funfm/sounds/logos/meta@2x.png" />

    <meta name="twitter:card" content="summary_large_image" />
    <meta name="twitter:image:src" content="https://static.tbrnet.de/images/funfm/sounds/logos/meta@2x.png" />
    <meta name="twitter:site" content="@fun_fm" />
    <meta name="twitter:creator" content="@fun_fm" />
    <meta name="twitter:title" content="FUN FM - SOUNDS">
    <meta name="twitter:description" content="Online. On the phone. On the Smartspeaker. On Demand. FUN FM SOUNDS">

    <meta itemprop="name" content="FUN FM - SOUNDS">
    <meta itemprop="description" content="Online. On the phone. On the Smartspeaker. On Demand. FUN FM SOUNDS">
    <meta itemprop="image" content="https://static.tbrnet.de/images/funfm/sounds/logos/meta@2x.png">

    <meta name="referrer" content="no-referrer">

    <script type="text/javascript" src="assets/js/jquery.min.js"></script>
</head>

<body>
<!--Launcher-->
<?php include'module/launcher.php'; ?>

<div class="fixed-top">
    <!-- Head Navline-->
    <nav class="head-nav">
        <div class="container">
            <div class="row no-gutters">
                <div class="col-md-2 col-lg-2 d-flex d-md-block mb-2 mb-md-0">
                    <img alt="Sounds Logo" class="sounds-logo-head"/>
                </div>
                <div class="col-md-8 col-lg-8 d-none d-sm-none d-md-flex">
                    <!--<a href="https://fun-fm.de" class="ext-link">Homepage</a>-->
                    <!--<button type="button" class="btn btn-icon" data-mdb-toggle="popover" title="Popover title" data-mdb-content="And here's some amazing content. It's very engaging. Right?"><span class="material-icons">help_outline</span></button>-->
                </div>
                <div class="col-md-2 col-lg-2 d-none d-sm-none d-md-flex pt-2 justify-content-end">
                    <a target="popup" class="popout_link text-white" onclick="window.open('https://sounds.fun-fm.com/popout','FUN FM SOUNDS PLAYER','width=550,height=950,srollbars=0')"><i class="far fa-clone"></i> Popout-Player</a>
                </div>
            </div>
        </div>
    </nav>
    <!--Broadcast Bar-->
    <nav class="broadcastbar d-none d-sm-none d-md-block">
        <div class="container">
            <div class="row no-gutters">
                <div class="col-md-2 col-lg-2 d-flex d-md-block justify-content-center mb-2 mb-md-0">
                    <button type="button" class="player-button playbtn btn-floating"><i class="fas play-pause fa-play"></i></button>
                    <button type="button" class="mute-button mutebtn btn-floating" accesskey="m"><i class="fas mute-unmute fa-volume-up"></i></button>
                    <div class="icon audio hidden">
                        <div class="sounds-equalizer sounds-equalizer-playing sounds-inline-flex" aria-hidden="true">
                            <div class="sounds-equalizer_bar"></div>
                            <div class="sounds-equalizer_bar"></div>
                            <div class="sounds-equalizer_bar"></div>
                            <div class="sounds-equalizer_bar"></div>
                        </div>
                    </div>
                </div>
                <div class="col-md-10 col-lg-10 d-flex align-items-center" id="nowplaying">
                    <div class="d-inline-block"><span id="api_lfm_display_name"></span>&nbsp;spielt:&nbsp;</div>
                    <div id="api_lfm_current_song1"></div>
                </div>
            </div>
        </div>
    </nav>
</div>


<!--Show Header -->
<section id="show_header" class="show-buehne show_theming" style="">

    <div class="container-fluid show-buehne-content">
        <div class="container" id="buehne-live-content">
            <div class="row">
                <div class="col-10">
                    <img alt="FUN FM Logo" class="funfm-logo-top"/>
                </div>
                <div class="col-2 text-right">
                    <button type="button" class="btn btn-black btn-contact" data-mdb-toggle="modal" data-mdb-target="#contactModal"><i class="far fa-comment-dots"></i></button>
                </div>
            </div>
            <div class="row">
                <div class="col-md-6 col-sm-12">
                    <div class="show_start_badge">
                        <svg class="show_start_badge" viewBox="0 0 288 112" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M104.72 27V83H140.32V72.36H117.12V27H104.72ZM145.243 27V36.84H151.403V73.16H145.243V83H169.883V73.16H163.723V36.84H169.883V27H145.243ZM205.674 83L223.674 27H210.794L198.634 71.48L186.554 27H173.274L191.274 83H205.674ZM228.079 27V83H265.039V72.76H240.479V59.4H262.479V49.48H240.479V37.24H265.039V27H228.079Z" fill="white"/>
                            <circle cx="52" cy="56" r="20" fill="white" class="live-pulse"/>
                            <circle cx="52" cy="56" r="32" stroke="white" stroke-width="8"/>
                        </svg>
                    </div><h5 class="show_start show_buehne"></h5>
                    <h2 class="show_name show_buehne"></h2>
                    <div class="marker"></div><br/>
                    <p class="show_description"></p>
                    <button type="button" class="btn livebtn btn-funfm" accesskey="r"><i class="fas fa-play"></i>&nbsp;&nbsp;Radio Einschalten</button>
                </div>
                <div class="col-md-6 d-none d-sm-none d-md-block text-right">
                    <h5 class="next_start show_buehne"></h5>
                    <h2 class="next_name show_buehne"></h2>
                    <div class="marker-right"></div><br/>
                    <p class="next_description"></p>
                </div>
            </div>
            <div class="row pt-4 pb-2 d-none d-sm-none d-md-block">
                <div class="col-md-12">
                    <div class="progress showprogress">
                        <div class="progress-bar show-progress show-progress-stage" role="progressbar" style="width: 75%;" aria-valuenow="75" aria-valuemin="0" aria-valuemax="100"></div>
                    </div>
                    <div class="row">
                        <div class="col-3 justify-content-start">
                            <p class="fullscreen_show_start"></p>
                        </div>
                        <div class="col-6 justify-content-center">
                            <p class="show_duration"></p>
                        </div>
                        <div class="col-3 d-flex justify-content-end align-content-end align-self-end align-items-end">
                            <p class="fullscreen_show_end"></p>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-3">
                            <div class="range player-desktop-ui">
                                <span class="material-icons" id="volume-min" onclick="SetVolume(0), SetSlider(0)">volume_down</span>
                                <input type="range" class="form-range slider" id="vol-control" min="0" max="100" step="1" value="100" oninput="SetVolume(this.value)" onchange="SetVolume(this.value)"/>
                                <span class="material-icons" id="volume-max" onclick="SetVolume(100), SetSlider(100)">volume_up</span>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="row">
                                <div class="col-2"></div>
                                <div class="col-2">
                                    <button id="seekBackTimeSinceShowStart" style="display:none" type="button" class="btn btn-md stage-mediactrl outerctrl">
                                    <span class="bwd_start_icon">
                                        <svg viewBox="0 0 103 104" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M45.117 8H37.7447L27.3006 21.5452L37.7447 35.1782H45.117L36.3404 21.6622L45.117 8ZM61.617 8H54.2447L43.7713 21.5452L54.2447 35.1782H61.617L52.1383 21.6622L61.617 8ZM32.6835 76.867H23C26.4299 82.8116 31.3954 87.7244 37.3763 91.0906C43.3572 94.4567 50.1333 96.1524 56.9947 96C62.1781 96.1349 67.3352 95.2197 72.1557 93.3095C76.9763 91.3994 81.3605 88.5338 85.0447 84.8851C88.7289 81.2365 91.6369 76.8802 93.5936 72.0784C95.5504 67.2766 96.5155 62.1286 96.4309 56.9441C96.4994 51.7758 95.5242 46.6468 93.5636 41.8643C91.603 37.0817 88.6974 32.7441 85.0207 29.1111C81.344 25.4782 76.9719 22.6246 72.1663 20.7213C67.3607 18.818 62.2204 17.9042 57.0532 18.0346H49.1835V25.0559H56.9947C61.1608 25.0594 65.2847 25.8898 69.1274 27.4991C72.9702 29.1083 76.4552 31.4643 79.3806 34.4305C82.306 37.3967 84.6135 40.9141 86.1693 44.7787C87.7251 48.6434 88.4984 52.7784 88.4442 56.9441C88.5422 61.086 87.7932 65.2043 86.2432 69.0465C84.6933 72.8886 82.3749 76.3738 79.4303 79.2883C76.4857 82.2027 72.9769 84.4851 69.119 85.9955C65.2611 87.5058 61.1353 88.2124 56.9947 88.0718C52.3612 88.1491 47.7698 87.1819 43.5611 85.2422C39.3525 83.3025 35.6347 80.44 32.6835 76.867Z"/>
                                            <path d="M14.32 65.384C17.944 65.384 20.872 63.56 20.872 60.176C20.872 54.032 11.968 55.472 11.968 52.496C11.968 51.488 12.88 50.864 14.248 50.864C16.216 50.864 17.104 51.944 17.728 53.12L20.728 51.608C19.336 49.232 17.272 47.816 14.152 47.816C10.84 47.816 8.10402 49.712 8.12802 52.616C8.17602 58.544 16.984 56.744 16.984 60.344C16.984 61.616 15.904 62.336 14.248 62.336C12.184 62.336 10.888 61.352 10.072 59.744L7.19202 61.376C8.87202 64.592 11.8 65.384 14.32 65.384Z"/>
                                            <path d="M21.8941 48.2V51.368H26.3341V65H30.0781V51.368H34.5181V48.2H21.8941Z"/>
                                            <path d="M48.6981 65L43.2981 48.2H38.9301L33.5301 65H37.4661L38.2821 62.096H43.8261L44.6421 65H48.6981ZM39.1221 59.12L41.0661 51.656L43.0101 59.12H39.1221Z"/>
                                            <path d="M63.7685 65L59.2565 58.472C61.4645 57.608 62.6885 55.928 62.6885 53.72C62.6885 50.576 60.2405 48.2 55.6085 48.2H50.1125V65H53.8805V59.144H55.6325L59.4245 65H63.7685ZM55.9445 51.296C57.5765 51.296 58.8005 52.256 58.8005 53.72C58.8005 55.52 57.5765 56.36 55.8725 56.36H53.8805V51.296H55.9445Z"/>
                                            <path d="M63.7535 48.2V51.368H68.1935V65H71.9375V51.368H76.3775V48.2H63.7535Z"/>
                                        </svg>
                                    </span>
                                    </button>
                                </div>
                                <div class="col-2">
                                    <button id="seekBack10Seconds" style="display:none" type="button" class="btn btn-md stage-mediactrl innerctrl">
                                    <span class="bwd_20s_icon">
                                        <svg viewBox="0 0 104 104" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M54.2447 8H61.617L54.6551 18.0346H57.0532C62.2203 17.9042 67.3607 18.818 72.1663 20.7213C76.9719 22.6246 81.344 25.4782 85.0207 29.1111C88.6973 32.7441 91.603 37.0817 93.5636 41.8643C95.5242 46.6468 96.4994 51.7758 96.4308 56.9441C96.5155 62.1286 95.5504 67.2766 93.5936 72.0784C91.6368 76.8802 88.7289 81.2365 85.0447 84.8851C81.3605 88.5338 76.9762 91.3994 72.1557 93.3095C67.3352 95.2197 62.1781 96.1349 56.9947 96C50.1333 96.1524 43.3571 94.4567 37.3763 91.0906C31.3954 87.7244 26.4299 82.8116 23 76.867H32.6835C35.6347 80.44 39.3525 83.3025 43.5611 85.2422C47.7698 87.1819 52.3612 88.1491 56.9947 88.0718C61.1353 88.2124 65.2611 87.5058 69.119 85.9955C72.9769 84.4851 76.4857 82.2027 79.4303 79.2883C82.3749 76.3738 84.6932 72.8886 86.2432 69.0465C87.7932 65.2043 88.5421 61.086 88.4441 56.9441C88.4984 52.7784 87.7251 48.6434 86.1693 44.7787C84.6135 40.9141 82.306 37.3967 79.3806 34.4305C76.4552 31.4643 72.9701 29.1083 69.1274 27.4991C65.2847 25.8898 61.1608 25.0594 56.9947 25.0559H54.5182L61.617 35.1782H54.2447L43.7713 21.5452L54.2447 8Z" id="seekArrowrwd"/>
                                            <path d="M47.5967 65V62.12H40.8767C45.2687 58.976 47.6447 56.624 47.6447 53.768C47.6447 51.032 45.6047 49.016 42.1007 49.016C38.8847 49.016 36.7247 51.008 36.0287 53.672L39.2927 54.44C39.7727 52.712 40.7327 51.872 41.9567 51.872C43.2287 51.872 43.9487 52.64 43.9487 53.864C43.9487 55.976 41.7887 58.112 36.0047 62.384V65H47.5967Z"/>
                                            <path d="M56.0008 65.384C60.2968 65.384 62.6248 62.096 62.6248 57.176C62.6248 52.328 60.3208 49.016 56.0008 49.016C51.6808 49.016 49.3528 52.328 49.3528 57.176C49.3528 62.096 51.7048 65.384 56.0008 65.384ZM56.0008 62.432C53.8408 62.432 53.0248 60.032 53.0248 57.176C53.0248 54.128 53.8408 51.872 56.0008 51.872C58.1368 51.872 58.9768 54.128 58.9768 57.176C58.9768 60.032 58.1368 62.432 56.0008 62.432Z"/>
                                            <path d="M69.1194 52.328C66.0474 52.328 64.1034 53.792 64.1034 56.024C64.1034 60.464 70.7274 59.456 70.7274 61.544C70.7274 62.24 70.0074 62.72 68.9514 62.72C67.7034 62.72 66.6954 62.168 65.8794 60.992L63.4794 62.624C64.7274 64.496 66.6234 65.384 69.1674 65.384C72.1194 65.384 74.3754 63.872 74.3754 61.4C74.3754 56.912 67.7034 57.704 67.7034 55.904C67.7034 55.448 68.1114 54.872 69.2874 54.872C70.3674 54.872 71.2554 55.4 71.8794 56.528L74.3274 55.112C73.3434 53.384 71.3514 52.328 69.1194 52.328Z"/>
                                        </svg>
                                    </span>
                                    </button>
                                </div>
                                <div class="col-2">
                                    <button id="seekForward10Seconds" style="display:none" type="button" class="btn btn-md stage-mediactrl innerctrl">
                                    <span class="fwd_20s_icon">
                                        <svg viewBox="0 0 104 104" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M52.8087 18.0333L45.8092 8H53.1221L63.5649 21.6604L53.1221 35.1746H45.8092L52.8245 25.0536H50.3725C46.2045 25.0533 42.0779 25.8807 38.2323 27.488C34.3867 29.0953 30.8986 31.4504 27.9705 34.4166C25.0424 37.3828 22.7326 40.9011 21.1752 44.7671C19.6177 48.6332 18.8436 52.7701 18.8979 56.9377C18.8035 61.0856 19.5578 65.2089 21.1145 69.0548C22.6711 72.9006 24.9972 76.3878 27.95 79.3023C30.9029 82.2168 34.4201 84.4971 38.286 86.0033C42.1518 87.5095 46.2847 88.2099 50.431 88.0613C55.0599 88.1405 59.6471 87.1743 63.8508 85.2345C68.0544 83.2947 71.7663 80.4315 74.7097 76.858H84.3334C80.9136 82.8037 75.9549 87.7182 69.9787 91.0846C64.0026 94.451 57.2298 96.145 50.3725 95.9885C45.1946 96.1153 40.0445 95.1943 35.2315 93.2808C30.4184 91.3674 26.0418 88.5009 22.3644 84.8535C18.687 81.2062 15.7847 76.8532 13.8318 72.056C11.8789 67.2589 10.9156 62.1165 11 56.9377C10.9314 51.7701 11.9065 46.6417 13.8668 41.8598C15.8272 37.0779 18.7325 32.7409 22.4087 29.1084C26.0849 25.4759 30.4564 22.6227 35.2614 20.7196C40.0664 18.8166 45.206 17.9029 50.3725 18.0333H52.8087Z" id="seekArrowfwd"/>
                                            <path d="M40.0966 65V62.12H33.3766C37.7686 58.976 40.1446 56.624 40.1446 53.768C40.1446 51.032 38.1046 49.016 34.6006 49.016C31.3846 49.016 29.2246 51.008 28.5286 53.672L31.7926 54.44C32.2726 52.712 33.2326 51.872 34.4566 51.872C35.7286 51.872 36.4486 52.64 36.4486 53.864C36.4486 55.976 34.2886 58.112 28.5046 62.384V65H40.0966Z"/>
                                            <path d="M48.5008 65.384C52.7968 65.384 55.1248 62.096 55.1248 57.176C55.1248 52.328 52.8208 49.016 48.5008 49.016C44.1808 49.016 41.8528 52.328 41.8528 57.176C41.8528 62.096 44.2048 65.384 48.5008 65.384ZM48.5008 62.432C46.3408 62.432 45.5247 60.032 45.5247 57.176C45.5247 54.128 46.3408 51.872 48.5008 51.872C50.6368 51.872 51.4767 54.128 51.4767 57.176C51.4767 60.032 50.6368 62.432 48.5008 62.432Z"/>
                                            <path d="M61.6194 52.328C58.5474 52.328 56.6034 53.792 56.6034 56.024C56.6034 60.464 63.2274 59.456 63.2274 61.544C63.2274 62.24 62.5074 62.72 61.4514 62.72C60.2034 62.72 59.1954 62.168 58.3794 60.992L55.9794 62.624C57.2274 64.496 59.1234 65.384 61.6674 65.384C64.6194 65.384 66.8754 63.872 66.8754 61.4C66.8754 56.912 60.2034 57.704 60.2034 55.904C60.2034 55.448 60.6114 54.872 61.7874 54.872C62.8674 54.872 63.7554 55.4 64.3794 56.528L66.8274 55.112C65.8434 53.384 63.8514 52.328 61.6194 52.328Z"/>
                                        </svg>
                                    </span>
                                    </button>
                                </div>
                                <div class="col-2">
                                    <button id="goToLivePosition" style="display:none" type="button" class="btn btn-md stage-mediactrl outerctrl">
                                    <span class="fwd_live_icon">
                                        <svg viewBox="0 0 103 104" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M62.2486 8L71.024 21.5434L62.2486 35.0576H69.6199L80.0627 21.5434L69.6199 8H62.2486ZM45.8092 8L55.2575 21.5434L45.8092 35.1746H53.1221L63.5649 21.6604L53.1221 8H45.8092ZM74.7097 76.858C71.7663 80.4315 68.0544 83.2947 63.8508 85.2345C59.6471 87.1743 55.0599 88.1405 50.431 88.0613C46.2847 88.2099 42.1518 87.5095 38.286 86.0033C34.4201 84.4971 30.9029 82.2168 27.95 79.3023C24.9972 76.3878 22.6711 72.9006 21.1145 69.0548C19.5578 65.2089 18.8035 61.0856 18.8979 56.9377C18.8436 52.7701 19.6177 48.6332 21.1752 44.7671C22.7326 40.9011 25.0424 37.3828 27.9705 34.4166C30.8986 31.4504 34.3867 29.0953 38.2323 27.488C42.0779 25.8807 46.2045 25.0533 50.3725 25.0536H58.1826V18.0333H50.3725C45.206 17.9029 40.0664 18.8166 35.2614 20.7196C30.4564 22.6227 26.0849 25.4759 22.4087 29.1084C18.7325 32.7409 15.8272 37.0779 13.8668 41.8598C11.9065 46.6417 10.9314 51.7701 11 56.9377C10.9156 62.1165 11.8789 67.2589 13.8318 72.056C15.7847 76.8532 18.687 81.2062 22.3644 84.8535C26.0418 88.5009 30.4184 91.3674 35.2315 93.2808C40.0445 95.1943 45.1946 96.1153 50.3725 95.9885C57.2298 96.145 64.0026 94.451 69.9787 91.0846C75.9549 87.7182 80.9136 82.8037 84.3334 76.858H74.7097Z"/>
                                            <path d="M49.464 48.2V65H60.168V61.76H53.232V48.2H49.464Z"/>
                                            <path d="M62.0968 48.2V65H65.8648V48.2H62.0968Z"/>
                                            <path d="M77.0559 65L82.4559 48.2H78.5199L74.9199 61.496L71.3439 48.2H67.2879L72.6879 65H77.0559Z"/>
                                            <path d="M83.8702 48.2V65H95.0062V61.904H87.6382V57.944H94.2382V54.92H87.6382V51.296H95.0062V48.2H83.8702Z"/>
                                        </svg>
                                    </span>
                                    </button>
                                </div>
                                <div class="col-2"></div>
                            </div>
                        </div>
                        <div class="col-3 text-right">
                            <div class="desktop-sharing">
                                <div class="btn-desktop-media-ui desktop-airplay" data-mdb-ripple-duration="0" data-mdb-toggle="tooltip" data-mdb-placement="bottom" title="AirPlay"><span class="material-icons">airplay</span></div>
                                <div class="btn-desktop-media-ui desktop-chromecast" data-mdb-ripple-duration="0" data-mdb-toggle="tooltip" data-mdb-placement="bottom" title="Chromecast"><span class="material-icons">cast</span></div>
                                <div class="dropup desktop-media-ui-sleeptimer-dropup">
                                    <div class="btn-desktop-media-ui desktop-sleeptime dropdown-toggle" type="button" id="sleepTimer" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" data-mdb-ripple-duration="0" data-mdb-toggle="tooltip" data-mdb-placement="bottom" title="Sleeptimer">
                                        <span class="material-icons">bedtime</span>
                                    </div>
                                    <div class="dropdown-menu desktop-media-ui-dropdown">
                                        <button class="dropdown-item" type="button" onclick="startTimer(15)">15 Min.</button>
                                        <button class="dropdown-item" type="button" onclick="startTimer(30)">30 Min.</button>
                                        <button class="dropdown-item" type="button" onclick="startTimer(45)">45 Min.</button>
                                        <button class="dropdown-item" type="button" onclick="startTimer(60)">60 Min.</button>
                                        <button class="dropdown-item" type="button" onclick="startTimer(90)">90 Min.</button>
                                        <button class="dropdown-item" type="button" onclick="startTimer(120)">120 Min.</button>
                                        <button class="dropdown-item" type="button" onclick="startTimer(180)">180 Min.</button>
                                    </div>
                                </div>
                                <div class="btn-desktop-media-ui desktop-sharer" data-mdb-ripple-duration="0" data-mdb-toggle="tooltip" data-mdb-placement="bottom" title="Teilen"><span class="material-icons">ios_share</span></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!--Station Infos-->
<section id="station_info">
    <div id="station" class="container d-none">
        <div class="row">
            <div class="col-md-3 mt-5 mt-md-4">
                <img id="station_logo" class="station_logo z-depth-1-half img-fluid" alt="Station Logo"/>
            </div>
            <div class="col-md-5 mt-4 station_info_container" id="station_info">
                <div class="station_details_container z-depth-1-half">
                    <h2 id="station_displayname"></h2>
                    <h4 id="station_slogan"></h4>
                    <p id="station_description"></p>
                    <div class="station_details_links d-sm-block d-md-none">
                        <a class="social-link link-lfm" id="lfm-link" target="_blank" rel="external nofollow noopener noreferrer"><i class="fas fa-headphones"></i></a>
                        <a class="social-link link-hp" id="hp-link" target="_blank" rel="external nofollow noopener noreferrer"><i class="fas fa-globe-europe"></i></a>
                        <a class="social-link link-fb" id="fb-link" target="_blank" rel="external nofollow noopener noreferrer"><i class="fab fa-facebook-f"></i></a>
                        <a class="social-link link-tw" id="tw-link" target="_blank" rel="external nofollow noopener noreferrer"><i class="fab fa-twitter"></i></a>
                        <a class="social-link link-ig" id="ig-link" target="_blank" rel="external nofollow noopener noreferrer"><i class="fab fa-instagram"></i></a>
                        <a class="social-link link-rss" id="rss-link" target="_blank" rel="external nofollow noopener noreferrer"><i class="fas fa-rss"></i></a>
                    </div>
                    <div class="btn-group btn_external d-none d-sm-none d-md-flex" role="group" aria-label="Playlist Links">
                        <a class="external_listening btn btn-sm btn-grey" type="button" id="radiode-link" rel="external nofollow noopener noreferrer">radio.de</a>
                        <a class="external_listening btn btn-sm btn-grey" type="button" id="phonostar-link" rel="external nofollow noopener noreferrer">phonostar</a>
                        <a class="external_listening btn btn-sm btn-grey" type="button" id="tunein-link" rel="external nofollow noopener noreferrer">tunein</a>
                        <a class="external_listening btn btn-sm btn-grey" type="button" id="m3u-link" rel="external nofollow noopener noreferrer">M3U</a>
                        <a class="external_listening btn btn-sm btn-grey" type="button" id="pls-link" rel="external nofollow noopener noreferrer">PLS</a>
                    </div>
                </div>
            </div>
            <div class="col-md-4 mt-4 station_info_container" id="playlist_wrapper">
                <div id="current_show" class="current_show_container z-depth-1-half mb-4">
                    <h4 class="show_start"></h4>
                    <h3 class="show_name"></h3>
                    <p class="show_description"></p>
                </div>
                <div id="next_show" class="current_show_container z-depth-1-half">
                    <h4 class="next_start"></h4>
                    <h3 class="next_name"></h3>
                    <p class="next_description"></p>
                </div>

            </div>
        </div>
    </div>
</section>


<main id="homeview" class="views homeview" style="display:block">
    <!-- Song history -->
    <section id="cover-flow">
        <div class="container" id="last_songs">
            <div class="row no">
                <div class="col-8 mt-5 mt-md-4">
                    <h3 class="last-songs-headline d-flex">Letzte Songs:</h3>
                </div>
                <div class="col-4 mt-5 mt-md-4 align-items-baseline hist-toogle-col">
                    <a onclick="histToggle()" class="d-flex align-self-end justify-content-end align-items-end align-self-end row-end-link text-white" target="_blank">Zum Songfinder&nbsp;&nbsp;<i class="fas fa-chevron-right"></i></a>
                </div>
            </div>
        </div>
        <div class="container-fluid scrolls" id="last_songs">
            <div id="song_row" class="row scrolls"></div>
        </div>

        <br/>
    </section>

    <section id="show_promo">
        <?php include'module/listen_show_promotion.inc.php';?>
    </section>

    <!-- Audio on Demand -->
    <section id="aod" class="">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <h3 class="aod-heading od-heading">On Demand:</h3>
                </div>
            </div>
        </div>
        <div class="container aod-content-carousel">
            <div class="row aod-row aod-content-row">
                <div class="col-md-6 col-sm-5 aod-content-col">
                    <div id="news" class="news_container aod-container z-depth-1-half">
                        <div class="aod-content">
                            <h5 id="news_head_1" class="aod-headline">Auf dem neusten Stand</h5>
                            <h3 id="news_head_2" class="aod-headline">Die Nachrichten</h3>
                            <div class="marker-aod"></div>
                            <button type="button" class="btn btn-sm newsbtn btn-funfm"><i class="fas fa-play"></i>&nbsp;&nbsp;Anh&ouml;ren</button>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-sm-5 aod-content-col">
                    <div id="news" class="wetter_container aod-container z-depth-1-half">
                        <div class="aod-content">
                            <h5 id="news_head_1" class="aod-headline">Sonne oder Regen?</h5>
                            <h3 id="news_head_2" class="aod-headline">Das Wetter</h3>
                            <div class="marker-aod"></div>
                            <button type="button" class="btn btn-sm weatherbtn btn-funfm"><i class="fas fa-play"></i>&nbsp;&nbsp;Anh&ouml;ren</button>
                        </div>
                    </div>
                </div>
                <!--<div class="col-md-3">
                    <div id="news" class="wirtschaft_container aod-container z-depth-1-half">
                        <div class="aod-content">
                            <h5 id="news_head_1" class="aod-headline">Vom 19.10.21</h5>
                            <h3 id="news_head_2" class="aod-headline">Wirtschaftsnews</h3>
                            <div class="marker-aod"></div>
                            <button type="button" class="btn btn-sm wirtschaft-1-btn btn-funfm"><i class="fas fa-play"></i> Anh&ouml;ren</button>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div id="news" class="current_show_container wirtschaft_container aod-container z-depth-1-half">
                        <div class="aod-content">
                            <h5 id="news_head_1" class="aod-headline">Vom 15.10.21</h5>
                            <h3 id="news_head_2" class="aod-headline">Wirtschaftsnews</h3>
                            <div class="marker-aod"></div>
                            <button type="button" class="btn btn-sm wirtschaft-1-btn btn-funfm"><i class="fas fa-play"></i> Anh&ouml;ren</button>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div id="news" class="current_show_container wirtschaft_container aod-container z-depth-1-half">
                        <div class="aod-content">
                            <h5 id="news_head_1" class="aod-headline">Vom 12.10.21</h5>
                            <h3 id="news_head_2" class="aod-headline">Wirtschaftsnews</h3>
                            <div class="marker-aod"></div>
                            <button type="button" class="btn btn-sm wirtschaft-1-btn btn-funfm"><i class="fas fa-play"></i> Anh&ouml;ren</button>
                        </div>
                    </div>
                </div>-->
            </div>
        </div>
    </section>
    <br/>
    <section id="last_show_episodes">
        <?php include 'module/listen_last_show_episode.inc.php';?>
    </section>
    <br/>
</main>


<main id="splanview" class="views splanview" style="display:none">
    <!-- Sendeplan -->
    <section id="schedule">
        <div class="container">
            <div class="row">
                <div class="col-12 mt-5 mt-md-4">
                    <h3 class="schedule-headline">Was l&auml;uft wann ?</h3>
                    <p>Welche Sendung kommt wann? Im FUN FM Sendeplan erfahrt ihr es.</p>
                    <br/><br/>
                </div>
            </div>
        </div>
        <?php include 'module/schedule.inc.php';?>
    </section>
</main>

<main id="plistview" class="views plistview" style="display:none">
    <div class="container">
        <div class="row">
            <div class="col-12 mt-5 mt-md-4">
                <h3 class="songfinder-headline">Vollst&auml;ndige Playlist</h3>
                <p>Musikrecherche & Playlist: Was lief wann bei FUN FM?</p>
            </div>
        </div>
        <?php include 'module/playlist.inc.php';?>
        <div class="row">
            <div class="col-12">
                <p>Die Titel, die im Sendeplan nicht erfasst sind, können unter <a class="link" href="mailto:musik@fun-fm.de">musik@fun-fm.de</a> angefragt werden.</p>
            </div>
        </div>
    </div>
</main>

<main id="spview" class="views spview" style="display: none">
    <?php include 'module/show_promo_view.inc.php';?>
</main>

<main id="newsview" class="views newsview" style="display: none">
    <?php include 'module/news.inc.php';?>
</main>

<main id="imprint" class="views imprint" style="display: none">
    <?php include  'module/imprint.inc.php';?>
</main>

<main id="dataprotection" class="views dataprotection" style="display: none">
    <?php include  'module/dataprotection.inc.php';?>
</main>

<main id="useragreement" class="views useragreement" style="display: none">
    <?php include 'module/useragreement.inc.php';?>
</main>

<!-- Footer -->
<footer class="page-footer font-small grey">
    <div class="container p-4">
        <div class="row">
            <div class="col-md-6">
                <h2 class="mb-3">Folge uns:</h2>
                <div class="station_details_links">
                    <a class="social-link-2 link-fb" id="fb-link" target="_blank" rel="external nofollow noopener noreferrer" href="https://www.facebook.com/funfm.de"><i class="fab fa-facebook-f"></i></a>
                    <a class="social-link-2 link-tw" id="tw-link" target="_blank" rel="external nofollow noopener noreferrer" href="https://twitter.com/fun_fm"><i class="fab fa-twitter"></i></a>
                    <a class="social-link-2 link-ig" id="ig-link" target="_blank" rel="external nofollow noopener noreferrer" href="https://instagram.com/funfm.de"><i class="fab fa-instagram"></i></a>
                    <a class="social-link-2 link-yt" id="yt-link" target="_blank" rel="external nofollow noopener noreferrer" href="https://www.youtube.com/user/funfm00"><i class="fab fa-youtube"></i></a>
                    <a class="social-link-2 link-rss" id="rss-link" target="_blank" rel="external nofollow noopener noreferrer" href="http://www.fun-fm.de/feed/"><i class="fas fa-rss"></i></a>
                </div>
            </div>
            <div class="col-md-6">
                <p style="padding-top: 10px; margin-bottom: 4px;">&copy; FUN FM</p>
                <p style="margin-bottom: 4px;">This station is powered by:</p>
                <a href="https://laut.fm/" rel="external nofollow noopener noreferrer">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 412 120" style="enable-background:new 0 0 412 120;" xml:space="preserve" alt="" class="lautfm-logo">
                        <path d="M59.3,0c7.7-0.1,15,1.2,20.6,3.4c2.7,1,5.4,1.9,7.7,3.3c3.2,1.8,6.1,3.5,8.9,5.6c8.7,6.6,15.3,15.3,19.7,26.2  c1.3,3.2,2.2,6.7,3,10.5c0.4,1.7,0.4,3.5,0.8,5.4c0.3,1.8,0.2,3.7,0.2,5.7c0,1.3,0.1,2.6-0.1,3.8c0,0.5-0.1,1.1-0.1,1.6  c-0.2,1.5-0.4,2.9-0.6,4.4c-0.9,4.5-1.9,8.7-3.5,12.5c-7.3,17.2-20.2,29.5-38.8,35.3c-2.4,0.7-4.9,1.2-7.5,1.7  c-1.1,0.1-2.3,0.3-3.4,0.4c-1.1,0.1-2.3,0.2-3.4,0.2c-0.6,0-1.1,0-1.7,0c-0.6,0-1.3,0-1.9,0c-0.5,0-1.1,0-1.6,0  c-1.4-0.2-3-0.1-4.3-0.4c-1.9-0.3-3.7-0.4-5.5-0.9c-1.8-0.4-3.5-0.8-5.2-1.3c-2.4-0.8-4.7-1.7-6.9-2.6  c-13.3-5.8-24.5-16.9-30.4-30.2c-1.1-2.5-2-5.1-2.9-7.8C1.5,74,1.1,71,0.5,67.9c-0.3-1.5-0.2-3.2-0.4-4.8c0-0.8,0-1.5-0.1-2.3  c0-0.5,0-1.1,0-1.6c0-0.9,0.1-1.8,0.1-2.7c0.3-1.7,0.2-3.4,0.5-5.1c0.8-3.9,1.3-7.5,2.6-10.8c1-2.7,1.9-5.4,3.3-7.8  c0.6-1,1.1-2.1,1.7-3.1c1.3-2.1,2.7-4.2,4.1-6.1c4-5.4,9.4-10.3,15.1-14c1.6-1,3.2-1.9,4.9-2.8c2.4-1.4,5.1-2.3,7.8-3.4  C43,2.3,46,1.7,49.1,1c1.2-0.2,2.3-0.4,3.5-0.5C54,0.3,55.5,0.2,57,0.1C57.7,0,58.5,0,59.3,0z M58.5,14.2c-0.4,0-0.7,0-1.1,0  c-1.1,0.1-2.3,0.2-3.4,0.3c-2.9,0.5-5.7,1-8.1,1.9c-8.3,3.2-14.1,8-18.9,14.8c-1.1,1.5-1.9,3.2-2.9,4.8c-1.2,2.1-2.1,4.4-2.9,6.9  c-0.3,1-0.8,2.2-0.8,3.5c-2.7,1.4-5.4,2.8-8.1,4.2c-0.1,1.7-0.3,3.4-0.4,5.2c0,1.3-0.1,2.6-0.1,3.9c0,1.3,0,2.7,0,4  c0,1.3,0.1,2.6,0.1,3.9c0.1,1.7,0.3,3.4,0.4,5.1c2.7,1.6,5.3,3.1,8,4.7c2.7,0,5.4,0,8,0c-0.9-2.1-1.4-4.5-1.9-7  c-0.1-1-0.3-1.9-0.4-2.9c-0.1-1.4-0.2-2.8-0.2-4.2c0-0.4,0-0.9,0-1.3c0-1.1,0-2.2,0-3.3c0-2.2,0-4.4,0.3-6.4  c0.1-0.6,0.1-1.3,0.2-1.9c0.4-2.1,0.7-4.1,1.3-6C30,36.9,33.8,31,39.4,26.7c1.7-1.3,3.5-2.6,5.6-3.5c2.2-1,4.6-1.9,7.2-2.6  c1.3-0.3,2.5-0.4,3.9-0.7c1-0.2,2,0,3.1-0.2c0.5,0,1.1,0,1.6,0c1.2,0.2,2.4,0.1,3.6,0.3c2.7,0.5,5.1,0.9,7.4,1.8  c8.5,3.3,13.5,8,17.8,15.4c1,1.6,1.6,3.5,2.3,5.4c1.1,2.8,1.4,5.8,2,9.1c0.4,2,0.4,4.3,0.4,6.5c0,1,0,2.1,0,3.1c0,0.5,0,1,0,1.4  c0,1.2-0.1,2.3-0.1,3.5c-0.1,1.2-0.3,2.3-0.4,3.5c-0.5,2.7-1.1,5.3-2,7.6c2.7,0,5.4,0,8,0c2.7-1.6,5.3-3.1,8-4.7  c0.1-1.7,0.3-3.5,0.4-5.2c0-1.4,0.1-2.8,0.1-4.1c0-1.1,0-2.1,0-3.2c0-0.4,0-0.8,0-1.2c0-0.8-0.1-1.7-0.1-2.5c-0.2-1.5-0.1-3-0.3-4.5  c-0.1-0.4,0-1-0.1-1.3c-2.1-1.1-4.1-2.1-6.2-3.2c-0.3-0.2-1.8-0.7-1.9-1c-0.3-1.1-0.4-2.1-0.7-3.1c-2.9-9.3-8.6-17-15.8-22.1  c-1.8-1.3-3.7-2.5-5.8-3.4c-2.7-1.2-5.6-2.1-8.9-2.9C65.5,14.3,62.2,14.2,58.5,14.2z M137.8,21.3c6.6,0,13.2,0,19.9,0  c0,25.7,0,51.5,0,77.2c-6.6,0-13.2,0-19.9,0C137.8,72.7,137.8,47,137.8,21.3z M339.7,21.3c0,3.3,0,6.5,0,9.8c-1.8,0-3.8-0.1-5.4,0.2  c-0.9,0.1-1.6,0.1-2.1,0.7c-0.8,1-0.6,3-0.6,4.7c2.7,0,5.4,0,8.1,0c0,3.3,0,6.7,0,10c-1.5,0-3.1,0-4.6,0c0,17.2,0,34.5,0,51.7  c-6.4,0-12.8,0-19.3,0c0-17.2,0-34.5,0-51.7c-1.3,0-2.6,0-3.9,0c0-3.3,0-6.7,0-10c1.3,0,2.6,0,3.9,0c0-3.4-0.1-8.1,1.1-10.3  C320.6,20.4,330.3,21.3,339.7,21.3z M59.5,25.4c-0.2,0-0.5,0-0.8,0c-0.8,0.1-1.7,0.1-2.5,0.2c-2.2,0.4-4.3,0.8-6.2,1.5  c-9.1,3.5-15.5,10-18.5,19.5c-0.4,1.4-0.7,2.8-0.9,4.3c-0.1,0.7-0.1,1.4-0.2,2.1c0,1.5,0,3,0,4.6c0,2.6-0.1,5.4,0.3,7.6  c0.1,1,0.3,1.9,0.4,2.9c0.6,2.8,1.2,5.4,2.2,7.9c2.3,6,5.4,11.1,8.6,16.2c1.2,1.9,2.5,3.6,3.7,5.4c1.4,2,2.7,3.8,5.2,4.8  c1.3,0.5,3.9,0.3,5.6,0.3c4,0,8,0,12,0c3.1-0.6,4.2-2.5,5.7-4.6c2.3-3.3,4.6-6.6,6.8-10.1c2.3-3.8,4.6-7.9,6.3-12.2  c0.9-2.4,1.5-5,2.1-7.6c0.7-3,0.7-6.4,0.7-10.1c0-4-0.1-7.6-1-10.6c-2.4-8.1-7-13.9-13.5-17.9C71.2,27.1,66.2,25.4,59.5,25.4z   M265.6,26.7c6.4,0,12.9,0,19.3,0c0,3.3,0,6.6,0,10c1.7,0,3.5,0,5.2,0c0,3.3,0,6.7,0,10c-1.7,0-3.5,0-5.2,0c0,10,0,20,0,29.9  c0,1.7,0,3.5,0,5.2c0.1,0.9,0,1.9,0.1,2.8c0.2,1,0,2.2,0.5,2.8c0.6,0.7,3.9,0.7,5.4,0.7c0,3.4,0,6.8,0,10.2c-2.8,0-5.5,0-8.3,0  c-1,0-2.1,0-3.1,0c-0.7,0-1.5,0-2.2-0.1c-1.7-0.3-3.3-0.3-4.8-0.7c-1.8-0.6-3.5-1.7-4.6-3.1c-0.7-0.8-1.3-1.8-1.6-2.9  c-0.3-1-0.3-2.2-0.5-3.4c0-0.4,0-0.8,0-1.2c0-0.9-0.1-1.8-0.1-2.7c0-1.7,0-3.5-0.1-5.2c0-10.8,0-21.5,0-32.3c-1.4,0-2.7,0-4.1,0  c0-3.3,0-6.7,0-10c1.4,0,2.7,0,4.1,0C265.6,33.4,265.6,30.1,265.6,26.7z M59.4,32.1c2.5,0,4.9,0.2,6.8,0.8  c8.8,2.6,15.1,8.5,17.5,17.5c0.6,2.4,0.6,5.3,0.6,8.4c0,2.5,0,4.8-0.4,6.9c-1.5,7.1-4.1,12.7-7.3,18.1c-2,3.4-4.1,6.7-6.3,9.9  c-0.6,0.9-1.5,2.4-2.4,3c-0.5,0.3-1.1,0.4-1.8,0.5c-3,0-6,0-9,0c-1.5,0-3.4,0.2-4.5-0.2c-1.2-0.4-1.7-1.5-2.4-2.4  c-1.5-2-3.1-4-4.4-6.2c-4.3-6.8-7.9-14.3-9.7-23.6c-0.3-1.8-0.3-3.8-0.3-5.9c0-3.5,0.1-6.7,0.9-9.4c2.4-7.8,7.6-13,15-15.9  c1.6-0.6,3.3-0.9,5.2-1.3C57.8,32.2,58.6,32.2,59.4,32.1z M207,98.4c-6.2,0-12.5,0-18.7,0c0-1.8,0-3.7,0-5.5c0,0,0,0,0,0  c-0.4,0.6-0.7,1.2-1.1,1.8c-1.1,1.5-2.5,2.6-4.1,3.6c-2.6,1.5-7.6,1.6-10.8,0.6c-2-0.6-4.5-1.7-5.7-3.2c-2.7-3.3-3-7.8-3-13.7  c0-1.5,0-2.9,0-4.4c0-0.5,0-1.1,0.1-1.6c0.4-2.4,0.7-4.5,1.8-6.2c1-1.4,2.7-2.3,4.3-3.2c3.2-1.9,7.2-3.2,10.7-4.7  c1.6-0.7,3.2-1.3,4.6-2.1c0.6-0.4,1.5-0.7,1.9-1.3c0.6-0.8,0.5-2.1,0.7-3.2c0-0.4,0-0.8,0-1.1c0.1-0.9,0.1-2.6,0-3.5  c0-0.6-0.1-1.3-0.1-1.9c-0.4-2-1-4.1-3.7-3.5c-2.1,0.4-1.7,1.9-2,4c0,0.8,0,1.7-0.1,2.5c0,2.6,0,5.2,0,7.8c-6,0-12.1,0-18.1,0  c0-5.8-0.1-11.5,1.6-15.5c1.5-3.5,5-6.5,8.5-8c8.7-3.8,24-2.6,29.1,3.6c1.3,1.6,2.4,3.2,3.1,5.5c0.5,1.8,0.4,4,0.8,6.1  c0,0.7,0.1,1.4,0.1,2.1c0,1,0.1,2,0.1,3c0,1.4,0,2.8,0.1,4.3c0,1.4,0,2.8,0,4.2c0,2.7,0,5.5,0,8.2C207,81.5,207,90,207,98.4z   M412,98.4c-6.2,0-12.5,0-18.7,0c0-13.5,0-26.9,0-40.4c0-1.2,0-2.4,0-3.6c0-0.7,0-1.4,0-2.2c0-0.7-0.1-1.4-0.1-2.1  c-0.4-2.6,0-4.5-2.6-4.9c-1.1-0.2-2,0.4-2.4,0.9c-0.7,0.9-0.6,2.2-0.8,3.6c0,0.7-0.1,1.5-0.1,2.2c0,0.6,0,1.1,0,1.7  c0,1.2,0,2.5,0,3.7c0,13.7,0,27.4,0,41.1c-6.2,0-12.5,0-18.7,0c0-13.5,0-26.9,0-40.4c0-1.8,0-3.5-0.1-5.3c0-1.1-0.1-2.1-0.1-3.1  c-0.2-1.4-0.1-2.7-0.8-3.5c-0.4-0.5-1-0.7-1.7-0.8c-1.2-0.2-2.1,0.5-2.5,1.1c-0.3,0.4-0.6,0.8-0.8,1.4c-0.3,1-0.1,2.4-0.2,3.6  c0,2,0,4,0,6c0,13.7,0,27.4,0,41c-6.2,0-12.5,0-18.7,0c0-21.1,0-42.2,0-63.3c6.3,0,12.7,0,19,0c-0.1,2-0.2,4-0.3,5.9c0,0,0,0,0,0  c0.4-1,1.4-1.8,2-2.6c2.4-2.9,8-5.5,13.6-4.1c3.1,0.8,5.4,2.3,7.1,4.4c0.6,0.7,1.4,1.5,1.7,2.3c0,0,0,0,0,0c0.4-1,1.5-1.9,2.2-2.7  c2.6-3.2,8.6-5.7,14.5-3.9c3,0.9,5.4,2.7,6.9,5.2c2.4,4,1.9,12.5,1.9,18.9C412,71.9,412,85.2,412,98.4z M213.3,35.2  c6.4,0,12.8,0,19.3,0c0,13.5,0,26.9,0,40.4c0,2,0,4,0,6c0,0.8,0,1.5,0.1,2.3c0.2,1.3,0,2.8,0.6,3.7c0.4,0.6,1.1,0.7,2,0.8  c1,0.2,2-0.3,2.4-0.8c0.6-0.8,0.4-2.2,0.6-3.4c0-0.8,0-1.5,0.1-2.3c0-1.9,0-3.8,0-5.7c0-13.7,0-27.3,0-41c6.4,0,12.8,0,19.3,0  c0,21.1,0,42.2,0,63.3c-6.5,0-13.1,0-19.6,0c0.1-1.7,0.2-3.5,0.3-5.2c0,0,0,0,0,0c-0.3,0.8-1.1,1.5-1.6,2.2  c-1.7,2.1-4.3,3.3-7.5,3.9c-1,0.2-2.4,0.3-3.5,0.1c-0.3,0-0.7,0-1,0c-0.9-0.2-1.8-0.2-2.6-0.5c-2.9-0.9-5.1-2.4-6.5-4.7  c-0.8-1.3-1.3-2.9-1.7-4.7c-0.3-1.2-0.1-2.6-0.4-4c0-0.5,0-0.9,0-1.4c0-0.8,0-1.6,0-2.3c0-2.4,0-4.8,0-7.3  C213.3,61.5,213.3,48.3,213.3,35.2z M187.8,68.4c-0.4,0.3-0.9,0.7-1.3,1c-1.3,1-3.1,2.6-3.8,4.2c-0.6,1.4-0.6,3-0.8,4.8  c-0.1,0.9-0.2,2.2,0,3.1c0,0.5,0,1.1,0,1.6c0.4,2.4,0.1,4.6,2.3,5.1c1.2,0.3,2.5-0.1,3-0.8c0.7-1,0.5-2.6,0.7-4c0-1.1,0-2.2,0-3.3  c0-2.1,0-4.3,0-6.4C187.8,72,187.8,70.2,187.8,68.4z M295.5,82.7c4.8,0,9.7,0,14.5,0c0,5.3,0,10.5,0,15.8c-4.8,0-9.7,0-14.5,0  C295.5,93.2,295.5,87.9,295.5,82.7z"/>
                    </svg>
                </a>
            </div>
        </div>
        <br/><br/>
        <div class="row">
            <div class="col-md-6 col-sm-12">
                <p style="margin-bottom: 4px;">FUN FM is a Brand of:</p>
                <!--<a href="" rel="external nofollow noopener noreferrer">-->
                    <svg viewBox="0 0 838 128" xmlns="http://www.w3.org/2000/svg" class="lautfm-logo tbr-logo">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M128 0H0V128H128V0ZM73.6818 37.496H92.8338L94.6258 23.384H35.2658V37.496H55.3138V101H73.6818V37.496Z"/>
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M271 0H143V128H271V0ZM233.59 65.608C230.379 62.7707 226.198 60.8667 221.046 59.896C225.077 58.9253 228.438 57.0587 231.126 54.296C233.888 51.4587 235.27 47.7627 235.27 43.208C235.27 36.1893 232.395 31.1493 226.646 28.088C220.896 24.952 212.571 23.384 201.669 23.384H179.717V101H204.693C215.371 101 223.659 99.32 229.558 95.96C235.531 92.5253 238.518 86.664 238.518 78.376C238.518 72.7013 236.875 68.4453 233.59 65.608ZM198.085 54.408V36.376H203.462C208.016 36.376 211.339 37.048 213.43 38.392C215.52 39.6613 216.566 41.864 216.566 45C216.566 51.272 212.683 54.408 204.917 54.408H198.085ZM215.782 85.544C213.318 86.9627 209.659 87.672 204.805 87.672H198.085V66.616H206.15C215.109 66.616 219.59 70.2 219.59 77.368C219.59 81.3253 218.32 84.0507 215.782 85.544Z"/>
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M415 0H287V128H415V0ZM342.086 71.32H349.254L365.158 101H385.878L366.165 67.96C371.318 65.6453 375.088 62.8453 377.478 59.56C379.867 56.2 381.061 52.0187 381.061 47.016C381.061 39.0267 378.374 33.0907 372.997 29.208C367.696 25.3253 359.744 23.384 349.142 23.384H323.717V101H342.086V71.32ZM349.814 58.664H342.086V36.264H348.694C353.248 36.264 356.608 37.1227 358.773 38.84C361.014 40.5573 362.133 43.2827 362.133 47.016C362.133 51.048 361.088 53.9973 358.997 55.864C356.981 57.7307 353.92 58.664 349.814 58.664Z"/>
                        <path d="M481.448 71.64H499.256V73.88C499.256 82.728 490.856 89 481.336 89C469.24 89 462.744 79.368 462.744 63.8C462.744 48.232 469.8 38.824 482.008 38.824C492.424 38.824 496.68 43.864 499.592 50.472L517.064 43.304C510.456 28.968 498.36 22.808 481.896 22.808C460.616 22.808 442.136 37.032 442.136 63.912C442.136 92.92 461.064 104.904 478.536 104.904C488.84 104.904 496.232 100.648 501.272 94.936V103H518.072V57.192H481.448V71.64Z"/>
                        <path d="M598.144 103L577.424 72.424C587.168 68.392 592.656 61.112 592.656 50.808C592.656 35.128 580.56 24.6 558.048 24.6H532.624V103H552.672V76.008H558.16L575.072 103H598.144ZM559.84 40.728C566.784 40.728 572.048 44.76 572.048 50.808C572.048 58.424 566.784 61.896 559.392 61.896H552.672V40.728H559.84Z"/>
                        <path d="M641.731 22.808C621.459 22.808 602.419 35.464 602.419 63.688C602.419 93.032 623.251 104.792 641.731 104.792C662.115 104.792 681.042 91.464 681.042 63.912C681.042 33.896 660.323 22.808 641.731 22.808ZM641.731 39.16C653.715 39.16 660.435 48.792 660.435 64.024C660.435 80.04 652.035 88.44 641.731 88.44C629.859 88.44 623.026 79.256 623.026 63.576C623.026 48.008 631.091 39.16 641.731 39.16Z"/>
                        <path d="M741.278 24.6V72.2C741.278 82.392 736.798 88.328 727.166 88.328C717.534 88.328 713.054 82.392 713.054 72.2V24.6H693.005V72.872C693.005 90.904 703.87 104.792 727.166 104.792C749.902 104.792 761.326 90.904 761.326 72.872V24.6H741.278Z"/>
                        <path d="M776.11 24.6V103H796.158V78.696H802.542C824.718 78.696 837.934 68.84 837.934 51.48C837.934 35.128 825.838 24.6 802.318 24.6H776.11ZM796.158 63.016V40.728H804.558C811.95 40.728 817.214 44.76 817.214 51.48C817.214 59.544 811.95 63.016 803.998 63.016H796.158Z"/>
                    </svg>
                <!--</a>-->
            </div>
            <div class="col-md-6 col-sm-12">
                <h4>Mehr:</h4>
                <a onclick="imprintToggle()" accesskey="i" class="text-white">Impressum</a>&nbsp;|&nbsp;<a onclick="dataprotectionToggle()" accesskey="d" class="text-white">Datenschutz</a>&nbsp;|&nbsp;<a onclick="useragreeToggle()" accesskey="u" class="text-white">Nutzungsbedingungen</a>
            </div>
        </div>
        <br/><br/>
    </div>

</footer>
<!-- Footer -->



<!-- Mobile Playerbar-->
<section id="playerbar">
    <div class="container playerbar align-self-center align-content-center align-items-center d-sm-block d-md-none">
        <div class="row">
            <div class="col-2">
                <button type="button" class="btn playerbar-button playbtn btn-floating"><i class="fas play-pause fa-play"></i></button>
            </div>
            <div class="col-10 playerbar-text">
                <p class="playerbar-showname"></p>
                <p class="playerbar-titleupdate" id="api_lfm_current_song2"></p>
                <p class="playerbar-aod d-none"></p>
            </div>
        </div>
    </div>
</section>

<section id="playerfullframe" class="playerfullframe">
    <?php include 'module/player-frame.inc.php';?>
</section>

<!-- Navbar Bottom -->
<section id="nav-btm">
    <nav class="navbar fixed-bottom btm-nav text-white text-equals">
        <div class="container-fluid text-center btm-nav-cont no-gutters">
            <div class="col"><button onclick="homeToggle()" accesskey="h" class="btn home-btn" id="home-btn" style="color:#ffcc00"><i class="fas fa-home btm-nav-icon"></i><br class="d-sm-block d-md-none"/> Home</button></div>
            <div class="col"><button onclick="newsToggle()" accesskey="n" class="btn news-btn" id="news-btn" style="color:white"><i class="fas fa-newspaper btm-nav-icon"></i><br class="d-sm-block d-md-none"/> Aktuelles</button></div>
            <div class="col"><button onclick="schedToggle()" accesskey="s" class="btn splan-btn" id="splan-btn" style="color:white"><i class="far fa-calendar-alt btm-nav-icon"></i><br class="d-sm-block d-md-none"/> Sendeplan</button></div>
            <div class="col"><button onclick="histToggle()" accesskey="p" class="btn plist-btn" id="plist-btn" style="color:white"><i class="fas fa-list-ul btm-nav-icon"></i><br class="d-sm-block d-md-none"/> Playlist</button></div>
        </div>
    </nav>
</section>

<video class="live-player" id="audio" preload="none" playsinline></video>

<!-- Kontakt Modal-->
<?php include 'module/contact-modal.inc.php';?>

<script src="assets/js/jquery.min.js"></script>
<script src="assets/js/popper.min.js"></script>
<script src="assets/mdb6/js/mdb.min.js"></script>
<script src="assets/bootstrap/js/bootstrap.min.js"></script>
<script src="assets/js/fontawesome/all.min.js"></script>
<script src="assets/js/jquery.khan-shatyr.min.js"></script>
<script src="assets/js/sounds.js"></script>
<script src="assets/js/dev-tracklist.js"></script>
<script src="assets/js/hls.js"></script>
<script src="assets/js/sharing.js"></script>
<script src="assets/js/getrss.js"></script>
<script src="assets/js/getshowpromotion.js"></script>
<script src="assets/js/contactsender.js"></script>
<script src="assets/js/swiper.js"></script>
<script>

    $(document).ready(function() {
            window.setTimeout("fadeMyDiv();", 600); //call fade in 3 seconds

        $('.playerbar-text, .plff-close').click(function() {
            $('.playerfullframe-window').toggleClass('close');
            $('.views').toggleClass('fullframe-views-display');
            $('.page-footer').toggleClass('fullframe-footer-display');
            $('.show-buehne').toggleClass('show-buehne-display');
        });
        fetchRss();
        fetchRssSport();
        fetchRssStudioblog();
        fetchRssAV();
        fetchpromoAOD();
        cycle();
        }
    )

    document.addEventListener('DOMContentLoaded', () => {
        const audioplayer = document.querySelector(".live-player")
        const aipbutton = document.querySelector(".airplay-button")
        const aipbuttondesktop = document.querySelector(".desktop-airplay")
        let isAirPlayAvailable = false

        audioplayer.addEventListener("webkitplaybacktargetavailabilitychanged", event => {
            if (event.availability === "available") {
                isAirPlayAvailable = true
                aipbuttondesktop.style.display = 'inline';
                aipbutton.style.display = 'inline-block';
            }
        })

        aipbutton.addEventListener("click", () => {
            if (isAirPlayAvailable) {
                audioplayer.webkitShowPlaybackTargetPicker()
            }
        })

        aipbuttondesktop.addEventListener("click", () => {
            if (isAirPlayAvailable) {
                audioplayer.webkitShowPlaybackTargetPicker()
            }
        })


    })


    function fadeMyDiv() {
        $(".launcher").fadeOut(1000);
    }

    function changeStageToShow() {
        $(".show-buehne").fadeOut(500);
        $(".show-buehne").slideUp(500);
        $(".show-buehne").hide(500);
        $(".aod-show-stage").fadeIn(500);
        $(".aod-show-stage").slideDown(500);
        $(".aod-show-stage").show(500);
    }
    function changeStageToLive() {
        $(".aod-show-stage").fadeOut(500);
        $(".aod-show-stage").slideUp(500);
        $(".aod-show-stage").hide(500);
        $(".show-buehne").fadeIn(500);
        $(".show-buehne").slideDown(500);
        $(".show-buehne").show(500);
    }

    /* =========================
     *  $_GET vars and checks
     * ========================= */
    let station         = 'funfm',
        color           = 'ffcc00'            || 'ffcc00';

    /* Boolean */
    let badges          = $_GET('badges')           || true,
        station_info    = $_GET('station_info')     || true,
        current_show    = $_GET('current_show')     || true,
        next_show       = $_GET('next_show')        || true,
        history         = $_GET('history')          || true,
        cover           = 'true'           || true;

    /* $_GET vars checks and translation */
    (badges == 'true' || badges == 'false')             ? badges = (badges == 'true')               : badges = true;
    (current_show == 'true' || current_show == 'false') ? current_show = (current_show == 'true')   : current_show = true;
    (next_show == 'true' || next_show == 'false')       ? next_show = (next_show == 'true')         : next_show = true;
    (station_info == 'true' || station_info == 'false') ? station_info = (station_info == 'true')   : station_info = true;
    (history == 'true' || history == 'false')           ? history = (history == 'true')             : history = true;
    (cover == 'true' || cover == 'false')               ? cover = (cover == 'true')                 : cover = false;


    /* =========================
     *  Other things
     * ========================= */

    /* Hide not wanted stuff from $_GET */
    !current_show   && $('#current_show').hide();
    !next_show      && $('#next_show').hide();
    !station_info   && $(function () {$('#station').hide(); $('#last_songs').css("margin-top", "5rem")});
    !history        && $('#last_songs').hide();

    if (!current_show && !next_show) {
        $("#playlist_wrapper").addClass("d-none");
        $("#station_info").removeClass("col-md-5").addClass("col-md-9");
    }

    let root = document.documentElement,
        sender = station.toUpperCase(),
        last_song_data_cache,
        song_str;
    root.style.setProperty('--main-color', '#' + color);
    !station && $("#api_lfm_current_song1").html("<artist>No Station Name given</artist>");

    function cycle() {
        setTimeout(function () {
            history && load_last_song(station);
            $('[data-toggle="popover"]').popover({trigger: 'focus'});
            getSong(station);
            crawlePlaylist(station);
            cycle();
        }, 2000);
    }

    $(document).ready(function () {
        audiobtn();
        history && load_last_songs_fully(station);
        crawleLautApi(station);
        getSong(station);
        getWidth();
        $("#api_lfm_current_song1").khanShatyr({delay: 2000, pause: 300, max_kerning: -0.01}).css('color', 'white');
        $(".playerbar-titleupdate").khanShatyr({delay: 2000, pause: 300, max_kerning: -0.01});
        cycle();
    });
</script>
<script>
    let currentview = $_GET('view'),
        schedday = $_GET('sched');

    let queryParams = new URLSearchParams(window.location.search);


    /* Set View by GET Parameter from URL */
    $(document).ready(function (){
        if (currentview === 'splanview') {
            schedToggle();
        } if (currentview === 'plistview') {
            histToggle();
        } if (currentview === 'homeview') {
            homeToggle();
        } if (currentview === 'imprint') {
            imprintToggle();
        } if (currentview === 'newsview') {
            newsToggle();
        } if (currentview === 'useragreement') {
            useragreeToggle();
        } if (currentview === 'datenschutz') {
            dataprotectionToggle();
        } else {
        }
    });


    function toggleView(viewName, btnName) {
        const views = ['homeview', 'plistview', 'splanview', 'spview', 'imprint', 'dataprotection', 'newsview', 'useragreement'];
        const buttons = ['home-btn', 'plist-btn', 'splan-btn', 'news-btn'];

        views.forEach(view => {
            document.getElementById(view).style.display = view === viewName ? 'block' : 'none';
        });

        buttons.forEach(button => {
            document.getElementById(button).style.color = button === btnName ? '#ffcc00' : 'white';
        });

        if (viewName) {
            queryParams.set('view', viewName);
            let newURL = `?view=${viewName}`;
            window.history.pushState(null, null, newURL);
        }

        window.scrollTo({ top: 0, behavior: 'smooth' });
    }

    function homeToggle() {
        toggleView('homeview', 'home-btn');
    }

    function histToggle() {
        toggleView('plistview', 'plist-btn');
    }

    function schedToggle() {
        toggleView('splanview', 'splan-btn');
        document.getElementById('onair').scrollIntoView({ behavior: 'smooth', block: 'center' });
    }

    function showpromoToggle() {
        toggleView('spview', null);
    }

    function imprintToggle() {
        toggleView('imprint', null);
    }

    function dataprotectionToggle() {
        toggleView('dataprotection', null);
    }

    function newsToggle() {
        toggleView('newsview', 'news-btn');
    }

    function useragreeToggle() {
        toggleView('useragreement', null);
    }

</script>

<!-- Matomo -->
<script>
    var _paq = window._paq = window._paq || [];
    /* tracker methods like "setCustomDimension" should be called before "trackPageView" */
    _paq.push(['trackPageView']);
    _paq.push(['enableLinkTracking']);
    (function() {
        var u="https://analytics.timbruenjes.de/";
        _paq.push(['setTrackerUrl', u+'matomo.php']);
        _paq.push(['setSiteId', '2']);
        var d=document, g=d.createElement('script'), s=d.getElementsByTagName('script')[0];
        g.async=true; g.src=u+'matomo.js'; s.parentNode.insertBefore(g,s);
    })();
</script>
<!-- End Matomo Code -->



<script type="text/template" id="song_detailed">
    <div class="col-md-4">
        <div class="last_song d-flex z-depth-1-half">
            <span class="track_nr">{{track_nr}}</span>
            <div class="song_wrapper">
                <h4 class="last_text last_artist">
                    {{artist}}
                </h4>
                <p class="last_text last_title">
                    {{title}}
                </p>
            </div>
            <div class="last_btn">
                <a tabindex="0" role="button" data-toggle="popover" data-trigger="focus" title="{{artist}}" data-content="{{title}}">
                    <i class="fas fa-info-circle"></i>
                </a>
            </div>
        </div>
    </div>
</script>
<script type="text/template" id="song_detailed_cover">
    <div class="card text-white last_song d-inline-block">
        <img src="{{cover}}" class="card-img cover" alt=""/>
        <div class="card-img-overlay song_wrapper mask">
            <!--<p class="card-text last_text last_time">&nbsp;{{time}}</p>-->
            <h3 class="card-title last_text last_artist">{{artist}}</h3>
            <p class="card-text last_text last_title">{{title}}</p>
            <div class="last_btn">
                <a tabindex="0" role="button" data-mdb-container="body" data-mdb-toggle="popover" data-mdb-trigger="focus" title="{{artist}}" data-mdb-content="{{title}}" class="last-songs-popover-toggle">
                    <i class="fas fa-info-circle"></i>
                </a>
            </div>
        </div>
    </div>
</script>
</body>
</html>
