<div class="container">
    <div class="row">
        <div class="col-12">
            <h3>Welche Show l&auml;uft wann?</h3>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
<?php
define('STATION', 'funfm');
$days = array( "mon" => "Montag", "tue" => "Dienstag", "wed" => "Mittwoch", "thu" => "Donnerstag", "fri" => "Freitag", "sat" => "Samstag", "sun" => "Sonntag" );
function get_station_data() {
    $json = file_get_contents('https://api.laut.fm/station/' . STATION);
    $obj = json_decode($json);
    return $obj;
}
function get_song_data(){
    $json = file_get_contents('https://api.laut.fm/station/' . STATION . '/current_song');
    $obj = json_decode($json);
    return $obj;
}
function get_schedule_data(){
    $json = file_get_contents('https://api.laut.fm/station/' . STATION . '/schedule');
    $obj = json_decode($json);
    return $obj;
}
function get_schedules() {
    $schedule = get_schedule_data();
    $current_day = "";
    $schedules = array();
    foreach ($schedule as $entry) {
        if ($entry->day != $current_day){
            $schedules[$entry->day] = array();
            $current_day = $entry->day;
        }
        $the_schedule = array();
        $the_schedule['start'] = $entry->hour;
        $the_schedule['end'] = $entry->end_time;
        $the_schedule['name'] = $entry->name;
        $the_schedule['description'] = $entry->description;
        $schedules[$entry->day][] = $the_schedule;
    }
    return $schedules;
}
$schedules = get_schedules();
?>
<div class="card">
    <div class="card-header">
        <ul class="nav nav-tabs nav-fill card-header-tabs" id="sendeplan-list" role="tablist">
<?php
foreach($schedules as $day =>$the_schedules):
    echo '<li class="nav-item">'."\n";
    echo '<a class="nav-link" id="sendeplan" data-mdb-toggle="tab" href="#sendeplan-tabs-';
    echo $days[$day];
    echo '" role="tab" aria-controls="tab-';
    echo $days[$day];
    echo '" aria-selected="true">';
    echo $days[$day];
    echo '</a>'."\n";
    echo '</li>'."\n";
    endforeach;
    ?>
    </ul>
    </div>
    <div class="card-body">
        <div class="tab-content" id="sendeplan-content">
            <?php
            foreach($the_schedules as $schedule):
                echo '<div class="tab-pane fade" id="sendeplan-tabs-'.$days[$day].'" role="tabpanel" aria-labelledby="sendeplan-tab-'.$days[$day].'">';
                foreach ($entry as $item => $schedule)  {
                    echo "\t".'<div class="row show-row">'."\n".'<div class="col-2 show-col time-col">'."\n".'<h3>';
                    echo $schedule['start'].':00';
                    echo ' Uhr</h3>'."\n".'</div>'."\n".'<div class="col-10 show-col" style="background: linear-gradient(to right, #e8e8e8,#fff)"><h3>';
                    echo $schedule['name'];
                    echo '</h3><p>';
                    echo $schedule['description'];
                    echo '</p>'."\n".'</div>'."\n".'</div>'."\n";
            }
            echo "</div>";
endforeach;
echo '';
?>

    </div>
</div>
    <br/>
</div>
            <br/>