<!DOCTYPE html>
<html lang="de" xmlns="http://www.w3.org/1999/html">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, shrink-to-fit=no">
    <link rel="stylesheet" href="assets/css/loader.min.css">

    <!--WebApp Basics-->
    <meta name="apple-mobile-web-app-capable" content="yes"/>
    <meta name="apple-mobile-web-app-status-bar-style" content="black">


    <!--OpenGraph-->
    <meta property="og:site_name" content="fun-fm.de" />
    <meta property="article:tag" content="FUN FM - SOUNDS" />
    <meta property="og:type" content="article">
    <meta property="og:description" content="Online. On the phone. On the Smartspeaker. On Demand. FUN FM SOUNDS" />
    <meta property="og:image" content="https://static.tbrnet.de/images/funfm/sounds/logos/meta@2x.png" />

    <meta name="twitter:card" content="summary_large_image" />
    <meta name="twitter:image:src" content="https://static.tbrnet.de/images/funfm/sounds/logos/meta@2x.png" />
    <meta name="twitter:site" content="@fun_fm" />
    <meta name="twitter:creator" content="@fun_fm" />
    <meta name="twitter:title" content="FUN FM - SOUNDS">
    <meta name="twitter:description" content="Online. On the phone. On the Smartspeaker. On Demand. FUN FM SOUNDS">

    <meta itemprop="name" content="FUN FM - SOUNDS">
    <meta itemprop="description" content="Online. On the phone. On the Smartspeaker. On Demand. FUN FM SOUNDS">
    <meta itemprop="image" content="https://static.tbrnet.de/images/funfm/sounds/logos/meta@2x.png">

    <meta name="referrer" content="no-referrer">

    <script type="text/javascript" src="assets/js/jquery.min.js"></script>
</head>

<body class="popout-body">
<!--Launcher-->
<?php include'module/launcher.php'; ?>

<main class="popout-player-page">

    <!-- Sounds Branding Bar-->
    <div class="fixed-top">
        <!-- Head Navline-->
        <nav class="head-nav">
            <div class="container">
                <div class="row no-gutters">
                    <div class="col-12 text-center">
                        <img alt="Sounds Logo" class="sounds-logo-head popout"/>
                    </div>
                    <div class="col-md-10 col-lg-10 d-none d-sm-none d-md-flex">
                    </div>
                </div>
            </div>
        </nav>
    </div>

    <div class="popout-content">
        <div class="container">

            <!--Show Information-->
            <div class="row">
                <div class="col text-center justify-content-center">
                    <div class="show_cover_image justify-content-center">
                        <img class="img-fluid popout-show_cover"/>
                        <div class="equals_live_badge justify-content-center">
                            <svg class="equals_live_badge_coloring justify-content-center" viewBox="0 0 288 112" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M104.72 27V83H140.32V72.36H117.12V27H104.72ZM145.243 27V36.84H151.403V73.16H145.243V83H169.883V73.16H163.723V36.84H169.883V27H145.243ZM205.674 83L223.674 27H210.794L198.634 71.48L186.554 27H173.274L191.274 83H205.674ZM228.079 27V83H265.039V72.76H240.479V59.4H262.479V49.48H240.479V37.24H265.039V27H228.079Z" fill="white"></path>
                            <circle cx="52" cy="56" r="20" fill="white" class="live-pulse"></circle>
                            <circle cx="52" cy="56" r="32" stroke="white" stroke-width="8"></circle>
                        </svg>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-12 text-center">
                    <h3 class="popout-show_timing"></h3>
                    <h1 class="popout-show_name"></h1>
                    <a href="https://sounds.fun-fm.com/beta?view=schedule" class="btn btn-sm btn-funfm btn-popout_schedule" target="_blank" hidden>Sendeplan</a>
                </div>
            </div>

            <hr class="popout-divider" />

            <!--Curent Metadata-->
            <div class="row no-gutters">
                <div class="col cover-col">
                    <iframe src="https://cover.tbrnet.de/cover.html?station=funfm&width=128" class="popout-current_cover" scrolling="no"></iframe>
                </div>
                <div class="col">
                    <div class="popout_metadata">
                        <span class="equals_onair_badge">
                            <svg viewBox="0 0 368 112" xmlns="http://www.w3.org/2000/svg" class="equals_onair_badge">
                                <path d="M118 25.72C104.16 25.72 90.56 34.84 90.56 54.92C90.56 76.04 105.44 84.28 118 84.28C131.92 84.28 145.44 74.92 145.44 55.08C145.44 33.72 130.64 25.72 118 25.72ZM118 36.04C127.52 36.04 132.64 43.64 132.64 55.16C132.64 67.16 126.32 73.96 118 73.96C108.56 73.96 103.36 66.6 103.36 54.84C103.36 43.08 109.44 36.04 118 36.04ZM187.36 27V64.92L166.96 27H152.72V83H163.84V45.56L184.64 83H198.48V27H187.36ZM269.33 83L251.33 27H236.93L218.93 83H231.81L234.61 73.24H253.33L256.05 83H269.33ZM237.41 63.4L243.97 38.36L250.61 63.4H237.41ZM272.696 27V36.84H278.856V73.16H272.696V83H297.336V73.16H291.176V36.84H297.336V27H272.696ZM351.127 83L336.087 61.24C343.447 58.36 347.607 52.76 347.607 45.32C347.607 34.92 339.447 27 324.087 27H305.767V83H318.167V63.4H324.087L336.887 83H351.127ZM325.207 37.16C330.647 37.16 334.807 40.44 334.807 45.32C334.807 51.4 330.727 54.28 324.967 54.28H318.167V37.16H325.207Z"></path>
                                <path d="M19.8918 28V84L74.7004 56.0299L19.8918 28Z" class="sched-onair-animated"></path>
                            </svg>
                        </span>
                        <p class="popout_artist"></p>
                        <p class="popout_title"></p>
                    </div>
                </div>
            </div>


            <hr class="popout-divider" />

            <!--Player Controls-->
            <div class="row justify-content-center">
                <button type="button" class="btn btn-lg btn-popout_playbtn">
                    <i class="fas play-pause fa-play fa-2x"></i>
                </button>


            </div>
        </div>
    </div>
</main>




<video class="live-player" id="audio" preload="none" playsinline></video>


<script src="assets/js/jquery.min.js"></script>
<script src="assets/js/popper.min.js"></script>
<script src="assets/js/mdb/mdb.js"></script>
<script src="assets/bootstrap/js/bootstrap.min.js"></script>
<script src="assets/js/fontawesome/all.min.js"></script>
<script src="assets/js/jquery.khan-shatyr.min.js"></script>
<script src="assets/js/popout.js"></script>
<script src="assets/js/hls.js"></script>
<script>
    $(document).ready(function() {
            window.setTimeout("fadeMyDiv();", 600); //call fade in 3 seconds
        }
    )

    function fadeMyDiv() {
        $(".launcher").fadeOut(1000);
    }

    /* =========================
 *  $_GET vars and checks
 * ========================= */
    let station         = 'funfm',
        color           = 'ffcc00'            || 'ffcc00';

    /* Boolean */
    let badges          = $_GET('badges')           || true,
        station_info    = $_GET('station_info')     || true,
        current_show    = $_GET('current_show')     || true,
        next_show       = $_GET('next_show')        || true,
        history         = $_GET('history')          || true,
        cover           = 'true'           || true;

    /* $_GET vars checks and translation */
    (badges == 'true' || badges == 'false')             ? badges = (badges == 'true')               : badges = true;
    (current_show == 'true' || current_show == 'false') ? current_show = (current_show == 'true')   : current_show = true;
    (next_show == 'true' || next_show == 'false')       ? next_show = (next_show == 'true')         : next_show = true;
    (station_info == 'true' || station_info == 'false') ? station_info = (station_info == 'true')   : station_info = true;
    (history == 'true' || history == 'false')           ? history = (history == 'true')             : history = true;
    (cover == 'true' || cover == 'false')               ? cover = (cover == 'true')                 : cover = false;


    /* =========================
     *  Other things
     * ========================= */

    /* Hide not wanted stuff from $_GET */
    !current_show   && $('#current_show').hide();
    !next_show      && $('#next_show').hide();
    !station_info   && $(function () {$('#station').hide(); $('#last_songs').css("margin-top", "5rem")});
    !history        && $('#last_songs').hide();

    if (!current_show && !next_show) {
        $("#playlist_wrapper").addClass("d-none");
        $("#station_info").removeClass("col-md-5").addClass("col-md-9");
    }

    let root = document.documentElement,
        sender = station.toUpperCase(),
        last_song_data_cache,
        song_str;
    root.style.setProperty('--main-color', '#' + color);
    !station && $("#api_lfm_current_song1").html("<artist>No Station Name given</artist>");

    function cycle() {
        setTimeout(function () {
            getSong(station);
            crawlePlaylist(station);
            cycle();
        }, 2000);
    }

    $(document).ready(function () {
        audiobtn();
        crawleLautApi(station);
        getSong(station);
        cycle();
    });

</script>



<!-- Matomo -->
<script>
    var _paq = window._paq = window._paq || [];
    /* tracker methods like "setCustomDimension" should be called before "trackPageView" */
    _paq.push(['trackPageView']);
    _paq.push(['enableLinkTracking']);
    (function() {
        var u="https://analytics.timbruenjes.de/";
        _paq.push(['setTrackerUrl', u+'matomo.php']);
        _paq.push(['setSiteId', '2']);
        var d=document, g=d.createElement('script'), s=d.getElementsByTagName('script')[0];
        g.async=true; g.src=u+'matomo.js'; s.parentNode.insertBefore(g,s);
    })();
</script>
<!-- End Matomo Code -->



</body>
</html>
