<?php
define('STATION', 'funfm');
$days = array( "mon" => "Montag", "tue" => "Dienstag", "wed" => "Mittwoch", "thu" => "Donnerstag", "fri" => "Freitag", "sat" => "Samstag", "sun" => "Sonntag" );
function get_station_data() {
    $json = file_get_contents('https://api.laut.fm/station/' . STATION);
    $obj = json_decode($json);
    return $obj;
}
function get_song_data(){
    $json = file_get_contents('https://api.laut.fm/station/' . STATION . '/current_song');
    $obj = json_decode($json);
    return $obj;
}
function get_schedule_data(){
    $json = file_get_contents('https://api.laut.fm/station/' . STATION . '/schedule');
    $obj = json_decode($json);
    return $obj;
}
function get_schedules() {
    $schedule = get_schedule_data();
    $current_day = "";
    $schedules = array();
    foreach ($schedule as $entry) {
        if ($entry->day != $current_day){
            $schedules[$entry->day] = array();
            $current_day = $entry->day;
        }
        $the_schedule = array();
        $the_schedule['start'] = $entry->hour;
        $the_schedule['end'] = $entry->end_time;
        $the_schedule['name'] = $entry->name;
        $the_schedule['description'] = $entry->description;
        $schedules[$entry->day][] = $the_schedule;
    }
    return $schedules;
}
$schedules = get_schedules();
?>

<div class="tabs" align="center">
    <?php
    $i = 0;
    foreach($schedules as $day => $the_schedules):
        echo '<input type="radio" id="tab'.$i.'" name="tab"';
    include 'module/sendeplan-wochentag.inc.php';
    echo '>'."\n";
    echo '<label class="tabButton" for="tab'.$i.'">'.$days[$day].'</label>'."\n";
    echo '<div class="tab">'."\n";
    echo "<table class='table table-striped' id='splan-table'>";
    echo "<tr id='splan-head'><td id='splan-header-time'><i class='fas fa-clock'></i>&nbsp;Uhrzeit</td><td id='splan-header'><i class='far fa-calendar'></i>&nbsp;Sendung<br/><div id='splan-desc'><i class='far fa-comment'></i>&nbsp;Beschreibung</div></td></tr>";
    foreach($the_schedules as $schedule) {
        echo "\t"."<tr><td><p id='splan-shows'><div id='splan-time'>Ab ";
        echo $schedule['start'].':00';
        echo ' Uhr</div></td><td id="splan-show"><sendeplan-sendung>';
        include 'module/sendeplan-filter.inc.php';
        echo '</sendeplan-sendung> bei FUN FM<br/><div id="splan-desc">'."\n";
        echo $schedule['description'];
        echo '</div></p></td></tr>'."\n";
    }
    echo "</table>";
    echo '</div>'."\n";
    $i++;
    endforeach;
    ?>
</div>
